
/*  A Bison parser, made from /linen/homes/susan/NetSolve/src/InfoServer/iserv_parser.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	TOK_AND	257
#define	TOK_OR	258
#define	TOK_EQUALITY	259
#define	TOK_SUCCEEDS	260
#define	TOK_GET	261
#define	TOK_ENDQUERY	262
#define	TOK_PUT	263
#define	TOK_STAT	264
#define	TOK_LPAR	265
#define	TOK_RPAR	266
#define	TOK_QUITREQ	267
#define	TOK_ALNUMS	268
#define	TOK_QALNUMS	269
#define	TOK_INVALID	270
#define	LOWER_THAN_KEYVAL	271
#define	USING_KEYVAL	272


#include "infoserver_int.h"
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/*
 * We need this global variable for knowing what fd the
 * client we're parsing for is hanging on.
 */
int parse_client = -1;
/*
 * And the parser can be in two modes, one for parsing
 * ``interactive'' client stuff, and one for parsing the
 * log file.
 */
NS_IS_PMode_t parser_mode = NS_IS_PMode_Interactive;


/*
 * Stuff for statistical purposes
 */
static time_t   t_lastput = 0;
static time_t   t_lastget = 0;
static unsigned n_puts = 0;
static unsigned n_gets = 0;


time_t req_stat_lastput(void)
{
  return t_lastput;
}

time_t req_stat_lastget(void)
{
  return t_lastget;
}

unsigned req_stat_puts(void)
{
  return n_puts;
}

unsigned req_stat_gets(void)
{
  return n_gets;
}


int yyerror(char * err)
{
  fprintf(stderr, "yyerror(): %s\n", err);
  if(parse_client != -1) {
    char * tmp = (char*)malloc(strlen(err) + 200);
    if(!tmp) {
      push_to_client(parse_client,
		     "ERROR (parse error - no clarification due to memory shortage)\n");
      return 0;
    }
    sprintf(tmp, "ERROR (%s)\n", err);
    push_to_client(parse_client, tmp);
    free(tmp);
  }
  return 0;
}

/*
 * Real code
 */

static NS_IS_Expression * new_expression(void) 
{
  NS_IS_Expression * ret = (NS_IS_Expression*)malloc(sizeof(NS_IS_Expression));
  if(ret) memset(ret, 0, sizeof(NS_IS_Expression));
  return ret;
}

static NS_IS_Insertion * new_insertion(void) 
{
  NS_IS_Insertion * ret = (NS_IS_Insertion*)malloc(sizeof(NS_IS_Insertion));
  if(ret) memset(ret, 0, sizeof(NS_IS_Insertion));
  return ret;
}

static void delete_expression(NS_IS_Expression* e)
{
  if(!e)
    return;

  switch(e->etype) {
  case NS_IS_Exp_KeyValue:
    if(e->value) {
      free(e->value);
      e->value = 0;
    }
    /* fallthru */
  case NS_IS_Exp_KeyReq:
    if(e->key) {
      free(e->key);
      e->key = 0;
    }
    break;
  case NS_IS_Exp_Combination:
    delete_expression(e->lexp);
    e->lexp = 0;
    delete_expression(e->rexp);
    e->rexp = 0;
    break;
  default:
    fprintf(stderr, "Unknown expression type encountered\n");
  }
}

static void delete_insertion(NS_IS_Insertion* e)
{
  if(!e)
    return;
  if(e->key)
    free(e->key);
  if(e->value)
    free(e->value);
  if(e->next)
    delete_insertion(e->next);
  free(e);
}


typedef union {
  NS_IS_Expression * expr;
  NS_IS_Insertion * pexpr;
  char * keyname;
  char * value;
  NS_IS_Exp_RelOp_t rel_op;
  char * text;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		34
#define	YYFLAG		-32768
#define	YYNTBASE	19

#define YYTRANSLATE(x) ((unsigned)(x) <= 272 ? yytranslate[x] : 28)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     5,     7,     9,    11,    13,    15,    19,    23,
    25,    27,    29,    33,    37,    41,    45,    49,    54,    56
};

static const short yyrhs[] = {    20,
     0,    19,    20,     0,    21,     0,    22,     0,    13,     0,
    10,     0,    16,     0,     7,    24,     8,     0,     9,    25,
     8,     0,     5,     0,     6,     0,    26,     0,    26,    23,
    27,     0,    11,    24,    12,     0,    24,     3,    24,     0,
    24,     4,    24,     0,    26,     5,    27,     0,    26,     5,
    27,    25,     0,    14,     0,    15,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   165,   165,   167,   180,   199,   204,   209,   218,   223,   228,
   230,   235,   244,   256,   258,   269,   282,   293,   307,   311
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","TOK_AND",
"TOK_OR","TOK_EQUALITY","TOK_SUCCEEDS","TOK_GET","TOK_ENDQUERY","TOK_PUT","TOK_STAT",
"TOK_LPAR","TOK_RPAR","TOK_QUITREQ","TOK_ALNUMS","TOK_QALNUMS","TOK_INVALID",
"LOWER_THAN_KEYVAL","USING_KEYVAL","session","request","query","insertion","relation",
"qexp","pexp","keyname","value", NULL
};
#endif

static const short yyr1[] = {     0,
    19,    19,    20,    20,    20,    20,    20,    21,    22,    23,
    23,    24,    24,    24,    24,    24,    25,    25,    26,    27
};

static const short yyr2[] = {     0,
     1,     2,     1,     1,     1,     1,     1,     3,     3,     1,
     1,     1,     3,     3,     3,     3,     3,     4,     1,     1
};

static const short yydefact[] = {     0,
     0,     0,     6,     5,     7,     0,     1,     3,     4,     0,
    19,     0,    12,     0,     0,     2,     0,     0,     0,     8,
    10,    11,     0,     9,     0,    14,    15,    16,    20,    13,
    17,    18,     0,     0
};

static const short yydefgoto[] = {     6,
     7,     8,     9,    23,    12,    14,    13,    30
};

static const short yypact[] = {    -4,
    -7,   -12,-32768,-32768,-32768,     1,-32768,-32768,-32768,    -7,
-32768,    15,    20,    19,    23,-32768,    12,    -7,    -7,-32768,
-32768,-32768,     5,-32768,     5,-32768,-32768,    27,-32768,-32768,
   -12,-32768,    31,-32768
};

static const short yypgoto[] = {-32768,
    26,-32768,-32768,-32768,     3,     2,    -2,     9
};


#define	YYLAST		34


static const short yytable[] = {    15,
    33,    11,     1,    10,     2,     3,    11,     1,     4,     2,
     3,     5,    17,     4,    18,    19,     5,    18,    19,    29,
    27,    28,    20,    26,    21,    22,    24,    25,    15,    18,
    34,    16,    32,    31
};

static const short yycheck[] = {     2,
     0,    14,     7,    11,     9,    10,    14,     7,    13,     9,
    10,    16,    10,    13,     3,     4,    16,     3,     4,    15,
    18,    19,     8,    12,     5,     6,     8,     5,    31,     3,
     0,     6,    31,    25
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */

/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif



/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 3:
{
  /*
   * Process the query and kill the expression
   */
  if(parser_mode != NS_IS_PMode_Interactive) {
    fprintf(stderr, "Got interactive query in non-interactive mode\n");
  } else {    
    dbms_process_query(parse_client, yyvsp[0].expr);
  }
  delete_expression(yyvsp[0].expr);
  /* Account */
  t_lastget = time(0);
  n_gets ++;
;
    break;}
case 4:
{
  /*
   * Process the insertion and kill the expression
   */
  if(parser_mode != NS_IS_PMode_Interactive) {
    /*
     * Process a non-interactive insertion 
     */
    dbms_process_insertion(-1, yyvsp[0].pexpr);
  } else {
    /*
     * Process an interactive insertion 
     */
    dbms_process_insertion(parse_client, yyvsp[0].pexpr);
  } 
  delete_insertion(yyvsp[0].pexpr);
  /* Account */
  t_lastput = time(0);
  n_puts ++;
;
    break;}
case 5:
{
  /*
   * Quit connection
   */
  treat_quit(parse_client);
;
    break;}
case 6:
{
  /*
   * Treat stats request
   */
  treat_stats(parse_client);
;
    break;}
case 7:
{
  char obuf[1024]; /* fixed length content  - stack is ok */
  sprintf(obuf, "Bad character: 0x%X \"%c\"\n", yyvsp[0].text[0], isgraph(yyvsp[0].text[0]) ? (yyvsp[0].text[0]) : '.');
  fprintf(stderr, "%s", obuf);
  if(parse_client != -1)
    push_to_client(parse_client, obuf);
;
    break;}
case 8:
{
  yyval.expr = yyvsp[-1].expr;
;
    break;}
case 9:
{
  yyval.pexpr = yyvsp[-1].pexpr;
;
    break;}
case 10:
{
  yyval.rel_op = NS_IS_Equality;
;
    break;}
case 11:
{
  yyval.rel_op = NS_IS_Succeeds;
;
    break;}
case 12:
{
  if(!(yyval.expr = new_expression())) {
    if(yyvsp[0].keyname) free(yyvsp[0].keyname);
    fprintf(stderr, "Allocation error in qexp keyname parser\n");
  } else {
    yyval.expr->etype = NS_IS_Exp_KeyReq;
    yyval.expr->key = yyvsp[0].keyname;
    yyval.expr->key_ndx = find_key_index(yyvsp[0].keyname);
  }  
;
    break;}
case 13:
{
  if(!(yyval.expr = new_expression())) {
    if(yyvsp[-2].keyname) free(yyvsp[-2].keyname);
    if(yyvsp[0].value) free(yyvsp[0].value);
    fprintf(stderr, "Allocation error in qexp keyval parser\n");
  } else {
    yyval.expr->etype = NS_IS_Exp_KeyValue;
    yyval.expr->key = yyvsp[-2].keyname;
    yyval.expr->key_ndx = find_key_index(yyvsp[-2].keyname);
    yyval.expr->rel_op = yyvsp[-1].rel_op;
    yyval.expr->value = yyvsp[0].value;
  }  
;
    break;}
case 14:
{
  yyval.expr = yyvsp[-1].expr;
;
    break;}
case 15:
{
  if(!(yyval.expr = new_expression())) {
    delete_expression(yyvsp[-2].expr);
    delete_expression(yyvsp[0].expr);
    fprintf(stderr, "Allocation error in qexp combination parser\n");
  } else {
    yyval.expr->etype = NS_IS_Exp_Combination;
    yyval.expr->lexp = yyvsp[-2].expr;
    yyval.expr->comb_op = NS_IS_And;
    yyval.expr->rexp = yyvsp[0].expr;
  }  
;
    break;}
case 16:
{
  if(!(yyval.expr = new_expression())) {
    delete_expression(yyvsp[-2].expr);
    delete_expression(yyvsp[0].expr);
    fprintf(stderr, "Allocation error in qexp combination parser\n");
  } else {
    yyval.expr->etype = NS_IS_Exp_Combination;
    yyval.expr->lexp = yyvsp[-2].expr;
    yyval.expr->comb_op = NS_IS_Or;
    yyval.expr->rexp = yyvsp[0].expr;
  }  
;
    break;}
case 17:
{
  if(!(yyval.pexpr = new_insertion())) {
    if(yyvsp[-2].keyname) free(yyvsp[-2].keyname);
    if(yyvsp[0].value) free(yyvsp[0].value);
    fprintf(stderr, "Allocation error in pexp head parser\n");
  } else {
    yyval.pexpr->key = yyvsp[-2].keyname;
    yyval.pexpr->value = yyvsp[0].value;
    yyval.pexpr->next = 0;
  }
;
    break;}
case 18:
{
  if(!(yyval.pexpr = new_insertion())) {
    if(yyvsp[-3].keyname) free(yyvsp[-3].keyname);
    if(yyvsp[-1].value) free(yyvsp[-1].value);
    if(yyvsp[0].pexpr) delete_insertion(yyvsp[0].pexpr);
    fprintf(stderr, "Allocation error in pexp head parser\n");
  } else {
    yyval.pexpr->key = yyvsp[-3].keyname;
    yyval.pexpr->value = yyvsp[-1].value;
    yyval.pexpr->next = yyvsp[0].pexpr;
  }
;
    break;}
case 19:
{
  yyval.keyname = strdup(yyvsp[0].text);
;
    break;}
case 20:
{
  yyval.value = strdup(yyvsp[0].text);
;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */


  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
