/*****************************************************************/
/*      infoserver.c                                             */
/*      Jakob Oestergaard                                        */
/*---------------------------------------------------------------*/
/*  main()                                                       */
/*****************************************************************/

/*
 * The basic idea of the InfoServer is, that the agent will tell
 * it about which client submittet which job on which server,
 * and when a job completes. The InfoServer will also know the
 * history of the client job submissions and which clients and
 * servers have registered with the NetSolve system.
 * Other information tools, such as the Java monitoring GUI
 * can then easily access this information.
 *
 * The InfoServer is currently spawned directly by the agent
 * as a sub-process, but it can easily be moved to be a
 * standalone process (getting it's information from the
 * agent via. a TCP socket instead of a pipe), if this is
 * deemed necessary for scalability reasons.
 */

#include "infoserver.h"
#include "infoserver_int.h"
#include "socketutil.h"
#include <stdlib.h>

const char * infoserver_input_path = 0;
const char * infoserver_input_host = 0;
int infoserver_input_port = -1;

int main(int argc, char** argv)
{
  if(spawn_infoserver_int(NS_IS_PUBLIC))
    exit(1);

  exit(0);
}
