/**********************************************************/
/* hbm_wrappers.c					  */
/*							  */
/**********************************************************/

#ifdef HBMLM
#include "globus_hbm_client.h"
#endif

/*
 * register to the HBMLM
 */
int ns_hbmlm_register(int pid, char *hbmdchostname)
{
#ifdef  HBMLM
  int err;
  char dc_spec_str[512];
  globus_hbm_client_regerr_t hbm_reg_return_ptr;

  err = globus_module_activate(GLOBUS_HBM_CLIENT_MODULE);
  if (err != GLOBUS_SUCCESS)
  {
    fprintf(stderr,
       "Globus: Impossible to activate GLOBUS_HBM_CLIENT_MODULE\n");
    return -1;
  }

  sprintf(dc_spec_str,"(&(host=%s)(portnum=%d))",hbmdchostname,HBMDCPORT);
  err = globus_hbm_client_register(pid,
                                   dc_spec_str,
                                   GLOBUS_TRUE,
                                   NULL,
                                   &hbm_reg_return_ptr);
  if (err != GLOBUS_SUCCESS)
  {
    fprintf(stderr,
       "Globus: Impossible to register to hbmlm\n");
    return -1;
  }
  return 1;
#else
  return 0;
#endif
}

/*
 * ns_hbmlm_unregister_normal()
 */
int ns_hbmlm_unregister_normal(int pid)
{
#ifdef HBMLM
  int err;

  err = globus_hbm_client_unregister_all(pid, 
          GLOBUS_HBM_MSGTYPE_UNREGISTER_NORMAL);
  if (err != GLOBUS_SUCCESS)
  {
    fprintf(stderr,
      "Globus: Impossible to unregister to hbmlm\n");
    return -1; 
  }

  err = globus_module_deactivate(GLOBUS_HBM_CLIENT_MODULE);
  if (err != GLOBUS_SUCCESS)
  {
    fprintf(stderr,
      "Globus: Impossible to deactivate GLOBUS_HBM_CLIENT_MODULE\n");
    return -1; 
  }
#else
  return 0;
#endif  
}

/*
 * ns_hbm_unregister_abnormal()
 */
int ns_hbmlm_unregister_abnormal(int pid)
{
#ifdef HBMLM
  int err;

  err = globus_hbm_client_unregister_all(pid,
          GLOBUS_HBM_MSGTYPE_UNREGISTER_ABNORMAL);
  if (err != GLOBUS_SUCCESS)
  {
    fprintf(stderr,
      "Globus: Impossible to unregister to hbmlm\n");
    return -1;
  }

  err = globus_module_deactivate(GLOBUS_HBM_CLIENT_MODULE);
  if (err != GLOBUS_SUCCESS)
  {
    fprintf(stderr,
      "Globus: Impossible to deactivate GLOBUS_HBM_CLIENT_MODULE\n");
    return -1;
  }
#else
  return 0;
#endif
}
