/*****************************************************************/
/*      sendfarmedrequest.c                                      */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  sendfarmedrequest()                                          */
/*****************************************************************/

/*
 * sendFarmedRequest() 
 *
 */

#include <stdarg.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include "core.h"
#include "client.h"
#include "mnemonics.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "farming.h"

int sendFarmedRequest(int index, NS_ProblemDesc *pd,
                      NS_Object ***inputs, NS_Object ***outputs,
                      NS_Iterator **iterator_array,void ***tmp_output_ptrs,
                      NS_RequestDesc **rds)
{
  int j;
  NS_VoidStarOrInt *stackarray;

  inputs[index] = (NS_Object **)calloc(pd->nb_input_objects,sizeof(NS_Object*));
  outputs[index] = (NS_Object **)calloc(pd->nb_output_objects,sizeof(NS_Object*));

  for (j=0;j<pd->nb_input_objects;j++)
    inputs[index][j] = createEmptyObject(pd->input_objects[j]->object_type,
                                   pd->input_objects[j]->data_type);
  for (j=0;j<pd->nb_output_objects;j++)
    outputs[index][j] = createEmptyObject(pd->output_objects[j]->object_type,
                                   pd->output_objects[j]->data_type);

  if (assignConstantValues(pd,inputs[index],outputs[index]) == -1)
  {
    free(inputs[index]);
    free(outputs[index]);
    return ns_errno;
  }
  if (generateArrayFromIterators(pd,&stackarray,iterator_array) == -1)
  {
    free(inputs[index]);
    free(outputs[index]);
    return ns_errno;
  }

  if (arrayToObjects(NS_CALL_FROM_C,pd,inputs[index],outputs[index],stackarray) == -1)
  {
    free(inputs[index]);
    free(outputs[index]);
    return ns_errno;
  }

  if (assignFormulaValues(pd,inputs[index],outputs[index]) == -1)
  {
    free(inputs[index]);
    free(outputs[index]);
    return ns_errno;
  }

  /* Special preprocessing for the packed file type */
  for (j=0;j<pd->nb_input_objects;j++)
  {
    if (inputs[index][j]->object_type != NETSOLVE_PACKEDFILES)
      continue;
    inputs[index][j]->attributes.packedfiles_attributes.filenames =
         copyCharStarList(
            inputs[index][j]->attributes.packedfiles_attributes.filenames,
              inputs[index][j]->attributes.packedfiles_attributes.m);
  }
  for (j=0;j<pd->nb_output_objects;j++)
  {
    if (outputs[index][j]->object_type != NETSOLVE_PACKEDFILES)
      continue;
    outputs[index][j]->attributes.packedfiles_attributes.defaultprefix =
      (char *)(outputs[index][j]->attributes.packedfiles_attributes.filenames);
    outputs[index][j]->attributes.packedfiles_attributes.filenames = NULL;
  }

  /* Setting the major */
  for (j=0;j<pd->nb_input_objects;j++)
  {
    if (inputs[index][j]->object_type == NETSOLVE_MATRIX)
      inputs[index][j]->attributes.matrix_attributes.major = my_major;
    else if (inputs[index][j]->object_type == NETSOLVE_SPARSEMATRIX)
      inputs[index][j]->attributes.sparsematrix_attributes.major = my_major;
    else
      continue;
  }
  for (j=0;j<pd->nb_output_objects;j++)
  {
    if (outputs[index][j]->object_type == NETSOLVE_MATRIX)
      outputs[index][j]->attributes.matrix_attributes.major = my_major;
    else if (outputs[index][j]->object_type == NETSOLVE_SPARSEMATRIX)
      outputs[index][j]->attributes.sparsematrix_attributes.major = my_major;
    else
      continue;
  }

  /* Saving the tmp_output_ptr */
  tmp_output_ptrs[index] = (void **)calloc(pd->nb_output_objects,sizeof(void*));
  for (j=0;j<pd->nb_output_objects;j++)
  {
    if (outputs[index][j]->object_type == NETSOLVE_STRING)
      tmp_output_ptrs[index][j] =
        outputs[index][j]->attributes.string_attributes.ptr;
  }
  free(stackarray);

  /* sending the request */
  rds[index] = netsolveSendRequest(NS_NOASSIGNMENT, NULL,pd,inputs[index],outputs[index]);
  if (rds[index] == NULL)
  {
    reverseIterators(pd,iterator_array);
    return ns_errno;
  }
  else
  {
    sleep(1);
    return NetSolveNotReady;
  }
}
