/*****************************************************************/
/*      netsl_farm.c                                             */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  netsl_farm()                                                 */
/*****************************************************************/

/*
 * netsl_farm() : vararg C Farming interface
 *
 * netsl_farm("i=1,200","problem_name",....)
 *
 *  We assume : start < end and step=+1
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "mnemonics.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "farming.h"

int* netsl_farm(char *iteration,...)
{
  NS_ProblemDesc *pd;
  va_list argptr;
  int start,end;
  char *buf;
  NS_Iterator **iterator_array;
  int status;
  int i;
  int len;
  int *returned_value;

  if(!proxy_pid){  /*proxy needs to be started*/
    if(netslinit(NULL) < 0){
      returned_value = (int *)calloc(1,sizeof(int));
      returned_value[0] = -1;
      return returned_value;
    }
  }

  /* Getting the iteration */
  va_start(argptr,iteration); 
  buf = strdup(iteration);

  /* get the <start> end the <end> */
  if (sscanf(buf,"i=%d,%d",&start,&end) != 2)
  {
    free(buf);
    ns_errno = NetSolveBadIterationRange;
    returned_value = (int *)calloc(1,sizeof(int));
    returned_value[0] = -1;
    return returned_value;
  }
  free(buf);

  /* Get the problem name */
  buf = strdup((char*)va_arg(argptr,void*));

  /* Stripping off the parenthesis */
  
  len = strlen(buf);
  if (buf[len-2] != '(')
  {
    free(buf);
    ns_errno = NetSolveBadProblemName;
    returned_value = (int *)calloc(1,sizeof(int));
    returned_value[0] = -1;
    return returned_value;
  }
  if (buf[len-1] != ')')
  {
    free(buf);
    ns_errno = NetSolveBadProblemName;
    returned_value = (int *)calloc(1,sizeof(int));
    returned_value[0] = -1;
    return returned_value;
  }
  buf[len-2] = '\0';

  /* Getting the problem descriptor */
  status = netsolveInfo(buf,&pd);
  free(buf);
  if (status == -1)
  {
    returned_value = (int *)calloc(1,sizeof(int));
    returned_value[0] = -1;
    return returned_value;
  }

  if (constructIteratorArray(argptr,pd,&iterator_array,start) == -1)
  {
    returned_value = (int *)calloc(1,sizeof(int));
    returned_value[0] = ns_errno;
    return returned_value;
  }

  returned_value = netsl_farmX(start,end,pd,iterator_array);

  for (i=0;i<pd->calling_sequence->nb_args;i++)
    freeIterator(iterator_array[i]);
  free(iterator_array);
  freeProblemDesc(pd);

  return returned_value; 
}
