/*****************************************************************/
/*      iterator.c                                               */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "mnemonics.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "farming.h"

/*
 * freeIterator()
 */
void freeIterator(NS_Iterator *it)
{
  freeSpecificIterator(it->specific);
  free(it);
}

/*
 * freeSpecificIterator()
 */
void freeSpecificIterator(NS_SpecificIterator *it)
{
  switch(it->type)
  {
    case INT_ITERATOR:
      free(it->it.int_iterator->expression);
      free(it->it.int_iterator);
      break;
    case INT_ARRAY_ITERATOR:
      free(it->it.int_array_iterator->expression);
      free(it->it.int_array_iterator);
      break;
    case PTR_ARRAY_ITERATOR:
      free(it->it.ptr_array_iterator->expression);
      free(it->it.ptr_array_iterator);
      break;
  }
  free(it);
}

/*
 * ns_int()
 */
NS_Iterator *ns_int(char *s)
{
  NS_Iterator *it;

  it = (NS_Iterator*)calloc(1,sizeof(NS_Iterator));
  it->returned_type = INTEGER;
  it->specific = (NS_SpecificIterator *)calloc(1,sizeof(NS_SpecificIterator));
  it->specific->type = INT_ITERATOR;
  it->specific->it.int_iterator = (NS_IntIterator *)calloc(1,sizeof(NS_IntIterator));
  it->specific->it.int_iterator->expression = strdup(s);
  return it;
}

/*
 * ns_int_array()
 */
NS_Iterator *ns_int_array(int *array,char *expression)
{
  NS_Iterator *it;

  it = (NS_Iterator*)calloc(1,sizeof(NS_Iterator));
  it->returned_type = INTEGER;
  it->specific = (NS_SpecificIterator *)calloc(1,sizeof(NS_SpecificIterator));
  it->specific->type = INT_ARRAY_ITERATOR;
  it->specific->it.int_array_iterator = 
               (NS_IntArrayIterator *)calloc(1,sizeof(NS_IntArrayIterator));
  it->specific->it.int_array_iterator->array = array;
  it->specific->it.int_array_iterator->expression = strdup(expression);
  return it;
}

/*
 * ns_ptr_array()
 */
NS_Iterator *ns_ptr_array(void **array,char *expression)
{
  NS_Iterator *it;

  it = (NS_Iterator*)calloc(1,sizeof(NS_Iterator));
  it->returned_type = POINTER;
  it->specific = (NS_SpecificIterator *)calloc(1,sizeof(NS_SpecificIterator));
  it->specific->type = PTR_ARRAY_ITERATOR;
  it->specific->it.ptr_array_iterator =
               (NS_PtrArrayIterator *)calloc(1,sizeof(NS_PtrArrayIterator));
  it->specific->it.ptr_array_iterator->array = array;
  it->specific->it.ptr_array_iterator->expression = strdup(expression);
  return it;
} 


/*
 * getNext()
 */
NS_VoidStarOrInt getNext(NS_Iterator *it)
{
  NS_VoidStarOrInt stuff;

  stuff = getValue(it->specific,it->i);
  (it->i)++;
  return stuff;
}

/*
 * getValue()
 */
NS_VoidStarOrInt getValue(NS_SpecificIterator *it, int i)
{
  NS_VoidStarOrInt stuff;

  switch(it->type)
  {
    case INT_ITERATOR:
      stuff.i = evalInteger(it->it.int_iterator->expression,i);
      break;
    case INT_ARRAY_ITERATOR:
      stuff.i = (it->it.int_array_iterator->array)[
                    evalInteger(it->it.int_array_iterator->expression,i)];
      break;
    case PTR_ARRAY_ITERATOR:
      stuff.ptr = (it->it.ptr_array_iterator->array)[
                    evalInteger(it->it.ptr_array_iterator->expression,i)];
      break;
    default:
      fprintf(stderr,"Unknown ITERATOR\n");
      stuff.i = 0;
  }
  return stuff;
}

/*
 * evalInteger()
 */
int evalInteger(char *s,int i)
{
  return i;
}
