/*****************************************************************/
/*      generateArrayFromIterators.c                             */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  generateArrayFromIterators()                                 */
/*****************************************************************/

/*
 * generateArrayFromIterators() : 
 *
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "mnemonics.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "farming.h"

int generateArrayFromIterators(NS_ProblemDesc *pd,NS_VoidStarOrInt **stackarray,
                           NS_Iterator **iterator_array)
{
  NS_VoidStarOrInt *new;
  int nb_args = pd->calling_sequence->nb_args;
  int i;
  NS_Iterator *it;

  new = (NS_VoidStarOrInt *)calloc(nb_args,sizeof(NS_VoidStarOrInt));
  for (i=0;i<nb_args;i++)
  {
    it = iterator_array[i];
    if (it == NULL) /* IGNORE */
      continue;
    switch(it->returned_type)
    {
      case IGNORE:
        new[i].ptr = NULL;
        break;
      case POINTER:
        new[i].ptr = getNext(it).ptr;
        break;
      case INTEGER:
        new[i].i = getNext(it).i;
        break;
    }
  }
  *stackarray = new;
  return 1; 
}

int reverseIterators(NS_ProblemDesc *pd, NS_Iterator **iterator_array)
{
  int nb_args = pd->calling_sequence->nb_args;
  int i;
  NS_Iterator *it;

  for (i=0;i<nb_args;i++)
  {
    it = iterator_array[i];
    if (it == NULL) /* IGNORE */
      continue;
    switch(it->returned_type)
    {
      case IGNORE:
        break;
      case POINTER:
        (it->i)--;
        break;
      case INTEGER:
        (it->i)--;
        break;
    }
  }
  return 1;
}
