#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DEBUG 1

extern int netsl(char *nickname,...);

int construct_crs_system
(
 double **values,int **indices,int **pointers,int *nnzeros,
 int first,int local_size,int domain_size,int total_size);

int print_crs_matrix
(double *mv,int *idx,int *ptr, int domain_size,int local_size, int nnzeros,
		double* rhs_vector);

int print_result
(double *result, int local_size);

int main(int Argc,char **Args)
{
char which[10];
int i;
int status, info;
int total_size,domain_size, first, nnzeros, wanted, which_selection;
/* return results */
/* the matrix */
int *pointers,*indices;
double *values, *real_ev, *imag_ev, *vectors;

  printf("Give domain size: ");
  scanf("%d",&domain_size);
  printf("\n");
  printf("Number of eigenvectors: "); scanf("%d",&wanted); printf("\n");
  printf("Enter 1 .. 7\n");
  printf("1. Largest   2. Smallest  3. Largest reals  4. Smallest reals\n");
  printf("5. Largest imag.  6. Smallest imag. 7. Shift:");
  scanf("%d", &which_selection);
  if(which_selection == 1)
    strcpy(which, "LM");
  else if(which_selection == 2)
    strcpy(which, "SM");
  else if(which_selection == 3)
    strcpy(which, "LR");
  else if(which_selection == 4)
    strcpy(which, "SR");
  else if(which_selection == 5)
    strcpy(which, "LI");
  else if(which_selection == 6)
    strcpy(which, "SI");
  else if(which_selection == 7)
    strcpy(which, "shift");
  else{
    printf("wrong selection\n");
    return -1;
  }
 
  real_ev = (double*) malloc((wanted+1)*sizeof(double));
  imag_ev = (double*) malloc((wanted+1)*sizeof(double));
  vectors = (double*) malloc(total_size*wanted*sizeof(double));

  first = 0;
  total_size = domain_size * domain_size;

  construct_crs_system
    (&values,&indices,&pointers,&nnzeros,
     first,total_size,domain_size,total_size);

  status = netsl("arpack_solver()", total_size, nnzeros,
                values, indices, pointers, &wanted, which, real_ev, imag_ev, 
		vectors, &info);

  printf("real:\n");
  for(i=0; i< wanted; i++)
    printf("%f ", real_ev[i]);
  printf("\n");
  printf("imag:\n");
  for(i=0; i< wanted; i++)
    printf("%f ", imag_ev[i]);
  printf("\n");

  return 0;

}

int construct_crs_system
(double **values,int **indices,int **pointers,int *nnzeros,
 int first,int local_size,int domain_size,int total_size)
{
  int IJ,ijk,i,j;

  *nnzeros = 5*total_size;

  /* allocate */
  *pointers = (int *) malloc((local_size+1)*sizeof(int));
  *indices = (int *) malloc((*nnzeros+1)*sizeof(int));
  *values = (double *) malloc((*nnzeros+1)*sizeof(double));

  IJ = 0; ijk = 0;
  for ( i=0; i<domain_size; i++ ) {
    for ( j=0; j<domain_size; j++ ) {
      int I,J; double v;
      if (IJ>=first && IJ<first+local_size) {
	(*pointers)[IJ-first] = ijk;
	I = j + domain_size*i;
	v = -1.0;
	if ( i>0 ) {
	  J = I - domain_size; (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
	}
	if ( j>0 )   {
	  J = I - 1; (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
	}
	{
	  double v = 4.0; (*values)[ijk] = v; (*indices)[ijk] = I; ijk++;
	}
	if ( j<domain_size-1 ) {
	  J = I + 1; (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
	}
	if ( i<domain_size-1 ) {
	  J = I + domain_size; (*values)[ijk] = v; (*indices)[ijk] = J; ijk++;
	}
      }
      IJ++;
    }
  }
  (*pointers)[local_size] = ijk;

  return 0;
}

int print_crs_matrix
(double *mv,int *idx,int *ptr, int domain_size,int local_size, int nnzeros,
		double* rhs_vector)
{
int i;
      printf("values: \n");
      for(i=0;i< nnzeros+1;i++)
          printf("%f   ", mv[i]);
      printf("\n");
      printf("indices:\n");
      for(i=0;i< nnzeros+1;i++)
          printf("%d  ", idx[i]);
      printf("\n");
      printf("ptrs:\n");
      for(i=0;i<local_size+1;i++){
          printf("%d\t", ptr[i]);
      }
      printf("\n");
      printf("rhs:\n");
      for(i=0;i<local_size;i++){
          printf("%f\t", rhs_vector[i]);
      }
      printf("\n");

  return 0;
}

int print_result
(double *result, int local_size)
{
int i;
      printf("values: \n");
      for(i=0;i< local_size;i++)
          printf("%f   ", result[i]);
      printf("\n");

   return 0;
}
