function mandel
%Displays the graphical user interface

global iter_max iter_min iter;
global steps_max steps_min steps;

global guiwin;
global mandelwin;
global cframe;

global stxt_iter slider_iter txt_iter;
global stxt_steps slider_steps txt_steps;

global stxt_zoom pop_zoom;
global stxt_blocks pop_blocks;
global stxt_requests pop_requests;

global zoom_choices blocks_choices requests_choices;

global cmd_display cmd_reset cmd_quit;

global xmax xmin ymax ymin;

global x y;

x = 0;
y = 0;

xmax = 2;
xmin = -2;
ymax = 2;
ymin = -2;

zoom_choices = {'Zoom in X 16';
'Zoom in X 8';
'Zoom in X 4';
'Zoom in X 2';
'no Zoom';
'Zoom out X 2';
'Zoom out X 4';
'Zoom out X 8';
'Zoom out X 16'};

blocks_choices = {'1';'4';'9';'16';'25'};

requests_choices = {'1';'2';'3';'4';'5';'6';'7';'8';'9';'10'};

iter_max = 120;
iter_min = 10;
iter = 60;

steps_max = 300;
steps_min = 10;
steps = 200;

screen_size = get(0,'screensize');
%gui window
guiwin = figure('Name','NetSolve Matlab Client Demonstration',...
'NumberTitle','off',...
'position',[10 10 screen_size(3)/5 screen_size(4)/2]);
figure(guiwin);

%mandel window
mandelwin = figure('Name','NetSolve Matlab Client Demonstration',...
'NumberTitle','off','color',[0 0 0],...
'WindowButtonUpFcn','mandelwin_click',...
'position',...
[screen_size(3)/2 10 (screen_size(3)/2)-10 screen_size(4)/2]);
figure(mandelwin);

figure(guiwin);

%controls frame
cframe = uicontrol('Style','frame',...
'Units','normalized',...
'Position',[0 0 1 1]);

%static text displaying 'Iterations'
stxt_iter = uicontrol('Style','text','string','ITERATIONS',...
'units','normalized','position',[0.05 0.925 0.39 0.05]);

%static text displaying 'Steps'
stxt_steps = uicontrol('Style','text','string','STEPS',...
'units','normalized','position',[0.583 0.925 0.33 0.05]);

%slider controlling iterations
slider_iter = uicontrol('style','slider',...
'units','normalized','position',[0.167 0.6 0.1 .325],...
'max',[iter_max],'min',[iter_min],'value',iter,...
'callback','slider_iter_change');

%slider controlling steps
slider_steps = uicontrol('style','slider',...
'units','normalized','position',[0.67 0.6 0.1 .325],...
'max',[steps_max],'min',[steps_min],'value',steps,...
'callback','slider_steps_change');

%text displaying current iterations value
txt_iter = uicontrol('style','text','string',num2str(iter),...
'units','normalized','position',[0.0833 0.525 0.33 0.05]);

%text displaying current steps value
txt_steps = uicontrol('style','text','string',num2str(steps),...
'units','normalized','position',[0.5833 0.525 0.33 0.05]);

%static text displaying 'zoom factor'
stxt_zoom = uicontrol('style','text','string','ZOOM',...
'units','normalized','position',[0.0833 0.45 0.33 0.05],...
'HorizontalAlignment','left');

%list box containing zoom choices
pop_zoom = uicontrol('style','popupmenu',...
'string',zoom_choices,'value',5,...
'units','normalized','position',[0.4167 0.475 0.5 0.05]);

%static text displaying 'blocks'
stxt_blocks = uicontrol('style','text','string','BLOCKS',...
'units','normalized','position',[0.0833 0.35 0.33 0.05],...
'HorizontalAlignment','left');

%list box containing blocks choices
pop_blocks = uicontrol('style','popupmenu',...
'string',blocks_choices,'value',3,...
'units','normalized','position',[0.5833 0.375 0.33 0.05]);

%static text displaying 'requests'
stxt_requests = uicontrol('style','text','string','REQUEST WINDOW',...
'units','normalized','position',[0.0833 0.25 0.67 0.05],...
'HorizontalAlignment','left');

%list box containing requests choices
pop_requests = uicontrol('style','popupmenu',...
'string',requests_choices,'value',3,...
'units','normalized','position',[0.5833 0.275 0.33 0.05]);

%command button for displaying mandelbrot set
cmd_display = uicontrol('style','pushbutton',...
'string','DISPLAY',...
'units','normalized','position',[0.25 0.175 0.5 0.05],...
'callback','cmd_display_click');

%command button for resetting the display to defaults
cmd_reset = uicontrol('style','pushbutton','string','RESET',...
'units','normalized','position',[0.25 0.1 0.5 0.05],...
'callback','cmd_reset_click');

%command button for quitting the demo
cmd_quit = uicontrol('style','pushbutton','string','QUIT',...
'units','normalized','position',[0.25 0.025 0.5 0.05],...
'callback','cmd_quit_click');


