#include <stdio.h>
#include "core.h"

int ns_dsi_read_vector(DSI_OBJECT* dsi_obj, void* data, 
			int count, int data_type){
#ifdef DSI 
char* tmpbuf; 
int read_allowed;
int perm;
int offset, extent, length;
int return_value;
uid_t my_uid;

#ifdef DSI_IBP
struct ibp_timer ls_timeout;
#endif

  ns_errno = 0;

  tmpbuf = (char*)data;
  extent = netsolve_sizeof(data_type);

  length = count*extent;

  my_uid = getuid();

  if(my_uid == dsi_obj->dsi_file->uid){
    perm = dsi_obj->dsi_file->perm / 100;
  }
  else{
    perm = dsi_obj->dsi_file->perm % 10;
  }
  
  read_allowed = perm & 4;

  if(read_allowed && ((dsi_obj->dsi_file->flag&O_RDONLY) || 
			(dsi_obj->dsi_file->flag&O_RDWR))){

    offset = dsi_obj->offset;
    
    if(dsi_obj->dsi_file->storage_system == IBP){
#ifdef DSI_IBP

      ls_timeout.ServerSync = 10;
      ls_timeout.ClientTimeout = 10;

      return_value =
        IBP_load(dsi_obj->dsi_file->dsi_specifics.ibp.cap->readCap, 
                 &ls_timeout, tmpbuf, length, offset);
      if(return_value == 0){
        ns_errno = NetSolveIBPLoadError;
        return -1;
      }
  
      return return_value/extent;
#endif
    }
  }
  else{
    ns_errno = NetSolveDsiEACCESS;
    return -1;
  }
  return 0;
#else
  ns_errno = 0;
  return 0;
#endif

  ns_errno = NetSolveDsiDisabled;
  return 0;

}

int ns_dsi_read_matrix(DSI_OBJECT* dsi_obj, void* data, 
			int rows, int cols, int data_type){
  return ns_dsi_read_vector(dsi_obj, data, rows*cols, data_type);

}
