#include "core.h"

NS_LinkedList *dsi_files=NULL;
NS_LinkedList *dsi_objects=NULL;

int compDsiObject(void *key,void *d)
{
 
  if (key == NULL)
    return 1;

  if(key == d)
    return 1;

  return 0;
}

void freeDsiObject(void *d){
  free(d);
}

int insert_dsi_object(DSI_OBJECT* dsi_obj){
  if(dsi_objects == NULL){
    dsi_objects = newNSLinkedList();
  }
  NSitemInsert(dsi_objects, dsi_obj);
  return 1;
}

int remove_dsi_object(DSI_OBJECT* dsi_obj){
  if(dsi_objects == NULL){
    return -1;
  }
  else{
    if(is_dsi_object(dsi_obj) == 0)
      return -1;
    else{
      NSitemDelete(dsi_objects, dsi_obj, compDsiObject, freeDsiObject);
      return 1;
    }
  }
}

int is_dsi_object(void* obj){
DSI_OBJECT* dsi_obj;
DSI_OBJECT** dsi_obj_list;

  if(dsi_objects == NULL){
    return 0;
  }
  else{
    dsi_obj = (DSI_OBJECT*)obj;
    dsi_obj_list = (DSI_OBJECT**)
			NSitemLookup(dsi_objects, dsi_obj, compDsiObject);
    if(*dsi_obj_list == NULL){
      free(dsi_obj_list);
      return 0;
    }
    else{
      free(dsi_obj_list);
      return 1;
    }
  }
}

int compDsiFile(void *key,void *d)
{
 
  if (key == NULL)
    return 1;

  if(key == d)
    return 1;

  return 0;
}

int compDsiFileInObject(void *key,void *d)
{
DSI_FILE* dsi_file;

  if (key == NULL)
    return 1;

  dsi_file = ((DSI_OBJECT*)d)->dsi_file;

  if(key == dsi_file)
    return 1;

  return 0;
}

void freeDsiFile(void *d){
int i;
DSI_OBJECT **dsi_object_list;

  dsi_object_list = (DSI_OBJECT**)
		NSitemLookup(dsi_objects, d, compDsiFileInObject);

  i = 0;
  while(dsi_object_list[i] != NULL){
    remove_dsi_object(dsi_object_list[i]);
    i++;
  }

  free(d);
}

int insert_dsi_file(DSI_FILE* dsi_file){
  if(dsi_files == NULL){
    dsi_files = newNSLinkedList();
  }
  NSitemInsert(dsi_files, dsi_file);
  return 1;
}

int remove_dsi_file(DSI_FILE* dsi_file){
  if(dsi_files == NULL){
    return -1;
  }
  else{
    NSitemDelete(dsi_files, dsi_file, compDsiFile, freeDsiFile);
    return 1;
  }
}
