/*****************************************************************/
/*      nwsutils.c                                               */
/*      Karine Heydeman                                          */
/*      modified by Susan Blackford and Patrick Geoffray         */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include "core.h"
#include "nwsutils.h"

#ifdef NWS
int ahostcompose(  char * machineName, int machinePort, char * name)
{
char port[8];

 if ( strcpy(name,machineName) != NULL)
  
 if ( strcat(name,":") != NULL)
   {
     sprintf(port,"%i",machinePort);
     if (strcat(name,port) != NULL ) 
       return 0;
   }
 printf(" can't append : %s", machineName);
 return -1;

}

hostadmincompose(char * name, char * who, int machinePort)
{
  char  *port=0;
  if ( strcat(name,":") != NULL)
    if ( strcat(name,who) != NULL)
      if ( strcat(name,":") != NULL)
	{
	  port=(char *) malloc (8*sizeof(char));
          sprintf(port,"%i",machinePort);
	}
  if (strcat(name,port) != NULL ) 
    { 
      free(port);
      return 0;
    }
   
    
  printf(" can't append : %s", name);
  return(-1);
}


void processKillNWSHost(char *hostname,int givenport)
{
 int pid;
 char fullhostname[70];
 
 pid=fork();
 
 if (pid !=0)
   return;
 /* i am the son*/

 if (ahostcompose(hostname,givenport,fullhostname)== -1)
   {   fprintf(stderr," Error: killNWShost  composition  ...."); return;}

 if(
    execlp("ctrl_host",
	  "ctrl_host",
	  "halt",
	  fullhostname,
	  NULL) < 0)
   fprintf(stderr,"impossible to halt the NWS host, sorry");
 return;
}

int AdminNWSSensor(char *hostname, char *what,char * cmd)
{
  char host[100],result[100], *ptr;
  FILE * filedesc;
  char command[1024];

  strcpy(host,hostname);
  hostadmincompose(host,"sensor",NWS_DEFAULT_SENSOR_PORT);

  strcpy(command, "nws-hostadmin ");
  strcat(command, cmd);
  strcat(command, " ");
  strcat(command, host); 

  filedesc = popen(command, "r");
  if (filedesc == NULL)
    {
      fprintf(stderr, "NetSolve : error in killing NWS Sensor process\n");
      return -1;
    }
  if (fgets(result,100,filedesc) == NULL)
    fprintf(stderr,"NetSolve : error in reading result of the murder of NWS Sensor process \n");
  else
    {
      ptr = strchr(result, ' ');
      ptr++;
      
      strcpy(what, ptr);
      pclose(filedesc);
      return 1;
    }
  pclose(filedesc);
  return 0; 
}
    
int AdminNWSFore(char *hostname, char *what,char * cmd)
{
  char host[100],result[100], *ptr;
  FILE * filedesc;
  char command[1024];

  strcpy(host,hostname);
  hostadmincompose(host,"forecaster", NWS_DEFAULT_FORECASTER_PORT);
  
  strcpy(command, "nws-hostadmin ");
  strcat(command, cmd);
  strcat(command, " ");
  strcat(command, host); 

  filedesc = popen(command, "r");
  if (filedesc == NULL)
    {
      fprintf(stderr, "NetSolve : error in killing NWS Forecaster process\n");
      return -1;
    }
  if (fgets(result,100,filedesc) == NULL)
    fprintf(stderr,"NetSolve : error in reading result of the murder of NWS Forecaster process \n");
  else
    {
      ptr = strchr(result, ' ');
      ptr++;
      
      strcpy(what, ptr);
      pclose(filedesc);
      return 1;
    }
  pclose(filedesc);
  return 0; 
}

int AdminNWSMemory(char *hostname, char *what,char * cmd)
{
  char host[100],result[100], *ptr;
  FILE * filedesc;
  char command[1024];

  strcpy(host,hostname);
  hostadmincompose(host,"memory", NWS_DEFAULT_MEMORY_PORT);
  
  strcpy(command, "nws-hostadmin ");
  strcat(command, cmd);
  strcat(command, " ");
  strcat(command, host); 

  filedesc = popen(command, "r");
  if (filedesc == NULL)
    {
      fprintf(stderr, "NetSolve : error in killing NWS Memory process\n");
      return -1;
    }
  if (fgets(result,100,filedesc) == NULL)
    fprintf(stderr,"NetSolve : error in reading result of the murder of NWS Memory process \n");
  else
    {
      ptr = strchr(result, ' ');
      ptr++;
      
      strcpy(what, ptr);
      pclose(filedesc);
      return 1;
    }
  pclose(filedesc);
  return 0; 
}

int AdminNWSNameServer(char *hostname, char *what,char * cmd)
{
  char host[100],result[100], *ptr;
  FILE * filedesc;
  char command[1024];

  strcpy(host,hostname);
  hostadmincompose(host,"nameserver", NWS_DEFAULT_NAMESERVER_PORT);

  strcpy(command, "nws-hostadmin ");
  strcat(command, cmd);
  strcat(command, " ");
  strcat(command, host); 

  filedesc = popen(command, "r");
  if (filedesc == NULL)
    {
      fprintf(stderr, "NetSolve : error in killing NWS NameServer process\n");
      return -1;
    }
  if (fgets(result,100,filedesc) == NULL)
    fprintf(stderr,"NetSolve : error in reading result of the murder of NWS NameServer process \n");
  else
    {
      ptr = strchr(result, ' ');
      ptr++;
      
      strcpy(what, ptr);
      pclose(filedesc);
      return 1;
    }
  pclose(filedesc);
  return 0; 
}

#endif /* NWS */
