/*****************************************************************/
/*      mnemonics.c                                              */
/*      Version 1.0                      Henri Casanova          */
/*****************************************************************/

#include "core.h"
#include "mnemonics.h"

/*
 * getArgumentType()
 */
int getArgumentType(char *mnemoniclist)
{
  char *buf = strdup(mnemoniclist);
  char *firstmnemonic;
  int result=-1;

  firstmnemonic = strtok(buf,",\0");
  switch(firstmnemonic[0])
  {
    case '?':
      result = IGNORE;
      break;
    case 'O':
    case 'I':
    case 'i':
    case 'p':
      result = POINTER;
      break;
    case 'm':
    case 'n':
    case 'l':
    case 'f':
      result = INTEGER;
      break;
  }
  free(buf);
  return result;
}

/*
 * getIndex()
 */
int getIndex(char *mnemonic)
{
  switch(mnemonic[0])
  {
    case 'O':
    case 'I':
      return atoi(&(mnemonic[1]));
    case 'm':
    case 'n':
    case 'l':
    case 'p':
    case 'i':
    case 'f':
      return atoi(&(mnemonic[2]));
  }
  ns_errno = NetSolveInternalError;
  return -1;
}

/*
 * getIO()
 */
int getIO(char *mnemonic)
{
  if (mnemonic[0] == 'O')
    return OUTPUT;
  if (mnemonic[0] == 'I')
    return INPUT;
  if (mnemonic[0] == '?')
    return IGNORE;
  if (mnemonic[1] == 'O')
    return OUTPUT;
  if (mnemonic[1] == 'I')
    return INPUT;
  ns_errno = NetSolveInternalError;
  return -1;
}

/*
 * isStringArgument()
 *
 * returns 0 if not
 * returns 1 if its a real string
 * return 2 on T3E if it's not a real string (merely a char vector, matrix,...)
 */
int isStringArgument(NS_ProblemDesc *pd,char *list)
{
  NS_Object *obj;
  int index,IorO;
  char *mnemonic;
  char *buf = strdup(list);

  mnemonic = strtok(buf,"\0,\t ");
  index = getIndex(mnemonic);
  IorO = getIO(mnemonic);

  free(buf);

  if (IorO == INPUT)
    obj = pd->input_objects[index];
  else
   obj = pd->output_objects[index];

#ifdef PLAT_T3E
  if ((obj->object_type == NETSOLVE_MATRIX)||
      (obj->object_type == NETSOLVE_SPARSEMATRIX)||
      (obj->object_type == NETSOLVE_VECTOR)||
      (obj->object_type == NETSOLVE_SCALAR))
  {
    if (getArgumentType(list) == POINTER)
    {
      if (obj->data_type == NETSOLVE_CHAR)
        return 2;
      if (obj->data_type == NETSOLVE_B)
        return 2;
    }
  }
#endif

  if (obj->object_type == NETSOLVE_MATRIX)
    return 0;
  if (obj->object_type == NETSOLVE_SPARSEMATRIX)
    return 0;
  if (obj->object_type == NETSOLVE_VECTOR)
    return 0;
  if (obj->object_type == NETSOLVE_SCALAR)
    return 0;
  if (obj->object_type == NETSOLVE_PACKEDFILES)
    return 0;
  if (obj->object_type == NETSOLVE_STRING)
    return 1;
  if (obj->object_type == NETSOLVE_UPF)
    return 1;
  if (obj->object_type == NETSOLVE_FILE)
    return 1;

  ns_errno = NetSolveInternalError;
  return -1;
}

/*
 * assignValue()
 *
 *  this function is called from the C and Fortran clients
 */
void assignValue(NS_ProblemDesc *pd, NS_Object **input, NS_Object **output,
                 char *mnemonic, void *value)
{
  NS_Object *obj;
  int index = getIndex(mnemonic);
  int IorO = getIO(mnemonic);

  if (IorO == INPUT)
    obj = input[index];
  else
    obj = output[index];

  switch(mnemonic[0])
  {
    case 'I':
    case 'O':
      switch(obj->object_type)
      {
        case NETSOLVE_MATRIX:
          if(is_dsi_object(value)){
            obj->distributed = 1;
            obj->dsi_obj = (DSI_OBJECT *)value;
          }
          else{
            obj->attributes.matrix_attributes.ptr = value;
          }
          break;
        case NETSOLVE_SPARSEMATRIX:
          if(is_dsi_object(value)){
            obj->distributed = 1;
            obj->dsi_obj = (DSI_OBJECT *)value;
          }
          else{
            obj->attributes.sparsematrix_attributes.ptr = value;
          }
          break;
        case NETSOLVE_VECTOR:
          if(is_dsi_object(value)){
            obj->distributed = 1;
            obj->dsi_obj = (DSI_OBJECT *)value;
          }
          else{
            obj->attributes.vector_attributes.ptr = value;
          }
          break;
        case NETSOLVE_SCALAR:
            obj->attributes.scalar_attributes.ptr = value;
          break;
        case NETSOLVE_FILE:
          if(is_dsi_object(value)){
            obj->dsi_obj = (DSI_OBJECT *)value;
          }
          else{
            obj->attributes.file_attributes.filename = strdup((char*)value);
          }
          break;
        case NETSOLVE_PACKEDFILES:
          /* Make a copy HERE Later on !!!*/
          obj->attributes.packedfiles_attributes.filenames = value;
          break;
        case NETSOLVE_STRINGLIST:
          obj->attributes.stringlist_attributes.strings = value;
          break;
        case NETSOLVE_STRING:
          obj->attributes.string_attributes.ptr = value;
          break;
        case NETSOLVE_UPF:
          /* Make a copy HERE */
          obj->attributes.upf_attributes.filename = strdup((char*)value);
          obj->attributes.upf_attributes.language = 
                       getLanguageFromFilename((char*)value);
          if (obj->attributes.upf_attributes.language == -1)
          {
            fprintf(stderr,"Warning: Filename for UPF should en in '.f' or '.c'\n");
          }
          obj->attributes.upf_attributes.funcname = 
                       getFunctionNameFromFilename((char*)value);
          break;
      }
      break;
    case 'm':
      switch(obj->object_type)
      {
        case NETSOLVE_MATRIX:
          obj->attributes.matrix_attributes.m = *((int*)value);
          break;
        case NETSOLVE_SPARSEMATRIX:
          obj->attributes.sparsematrix_attributes.m = *((int*)value);
          break;
        case NETSOLVE_VECTOR:
          obj->attributes.vector_attributes.m = *((int*)value);
          break;
        case NETSOLVE_PACKEDFILES:
          obj->attributes.packedfiles_attributes.m = *((int*)value);
          break;
        case NETSOLVE_STRINGLIST:
          obj->attributes.stringlist_attributes.m = *((int*)value);
          break;
      }
      break;
    case 'n':
      switch(obj->object_type)
      {
        case NETSOLVE_MATRIX:
          obj->attributes.matrix_attributes.n = *((int*)value);
          break;
        case NETSOLVE_SPARSEMATRIX:
          obj->attributes.sparsematrix_attributes.n = *((int*)value);
          break;
      }
      break;
    case 'l':
      switch(obj->object_type)
      {
        case NETSOLVE_MATRIX:
          obj->attributes.matrix_attributes.l = *((int*)value);
          break;
      }
      break;
    case 'f':
      switch(obj->object_type)
      {
        case NETSOLVE_SPARSEMATRIX:
          obj->attributes.sparsematrix_attributes.f = *((int*)value);
          break;
      }
      break;
    case 'p':
      switch(obj->object_type)
      {
        case NETSOLVE_SPARSEMATRIX:
          obj->attributes.sparsematrix_attributes.rc_ptr = ((int*)value);
          break;
      }
      break;
    case 'i':
      switch(obj->object_type)
      {
        case NETSOLVE_SPARSEMATRIX:
          obj->attributes.sparsematrix_attributes.rc_index = ((int*)value);
          break;
      }
      break;
  }
  return;
}
