/*****************************************************************/
/*      mappingdesc.c                                            */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"

/*
 * freeMappingDesc()
 */
void freeMappingDesc(void *d)
{
  if (d == NULL)
    return;
  free(d);
}

/*
 * newMappingDesc()
 */
NS_MappingDesc *newMappingDesc(NS_ProblemDesc *pd,NS_ServerDesc *sd)
{
  NS_MappingDesc *new;
  new = (NS_MappingDesc *)calloc(1,sizeof(NS_MappingDesc));
  new->server_desc = sd;  
  new->problem_desc = pd;  
  new->nb_failures = 0;
  return new;
}

/*
 * compMappingDescServerKey()
 *
 * Used for the linked list
 */
int compMappingDescServerKey(void *key,void *d)
{
  NS_ServerDesc *sd;
  
  sd = ((NS_MappingDesc *)d)->server_desc;
  
  if (sd->host_desc->IPaddr == *((NS_IPaddr_type *)key))
    return 1;

  return 0;
}

/*
 * compMappingDescProblemKey()
 *
 * Used for the linked list
 */
int compMappingDescProblemKey(void *key,void *d)
{
  NS_ProblemDesc *pd;
  
  pd = ((NS_MappingDesc *)d)->problem_desc;
  
  if (!strcmp(pd->nickname,(char *)key))
    return 1;

  return 0;
}


/*
 * compMappingDescAllKey()
 *
 * Used for the linked list
 */
int compMappingDescAllKey(void *key,void *d)
{
  NS_ProblemDesc *pd;
  NS_ServerDesc *sd;
  NS_MappingDesc *md=(NS_MappingDesc *)key;
  int IPaddr;
  char *nickname;
  

  pd = ((NS_MappingDesc *)d)->problem_desc;
  sd = ((NS_MappingDesc *)d)->server_desc;

  IPaddr = ((NS_ServerDesc *)(md->server_desc))->host_desc->IPaddr;
  nickname = ((NS_ProblemDesc *)(md->problem_desc))->nickname;

  if ((!strcmp(pd->nickname,nickname))&&
      (sd->host_desc->IPaddr == IPaddr))
    return 1;

  return 0;
}

