/*****************************************************************/
/*      hostdesc.c                                               */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"

/*
 * freeHostDesc()
 */
void freeHostDesc(NS_HostDesc *d)
{
  if (d == NULL)
    return;
  if (d->hostname != NULL)
    free(d->hostname);
  free(d);
}

/*
 * newHostDesc()
 */
NS_HostDesc *newHostDesc()
{
  return (NS_HostDesc *)calloc(1,sizeof(NS_HostDesc));
}

/*
 * sendHostDesc()
 *
 * Sends a host descriptor on a communicator
 */
int sendHostDesc(NS_Communicator *comm,NS_HostDesc *hd)
{
  if (sendString(comm,hd->hostname) == -1)
    return -1;
  if (sendIPaddr(comm,&(hd->IPaddr)) == -1)
    return -1;
  if (sendInt(comm,hd->data_format) == -1)
    return -1;
  if (sendInt(comm,hd->speed) == -1)
    return -1;
  if (sendInt(comm,hd->host_status) == -1)
    return -1;
  if (sendInt(comm,hd->number_proc) == -1)
    return -1;
  return 1;
}

/*
 * recvHostDesc()
 *
 * receives a host descriptor on a communicator
 */
NS_HostDesc *recvHostDesc(NS_Communicator *comm)
{
  NS_HostDesc *new;

  new = newHostDesc();
  if (recvString(comm,&(new->hostname)) == -1)
  {
    freeHostDesc(new);
    return NULL;
  }
  if (recvIPaddr(comm,&(new->IPaddr)) == -1)
  {
    freeHostDesc(new);
    return NULL;
  }
  if (recvInt(comm,&(new->data_format)) == -1)
  {
    freeHostDesc(new);
    return NULL;
  }
  if (recvInt(comm,&(new->speed)) == -1)
  {
    freeHostDesc(new);
    return NULL;
  }
  if (recvInt(comm,&(new->host_status)) == -1)
  {
    freeHostDesc(new);
    return NULL;
  }
  if (recvInt(comm,&(new->number_proc)) == -1)
  {
    freeHostDesc(new);
    return NULL;
  }
  return new;
}
