/*****************************************************************/
/*      agentdesc.c                                              */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"

/*
 * freeAgentDesc()
 */
void freeAgentDesc(void *d)
{
  NS_AgentDesc *ad = (NS_AgentDesc *)d;
  if (ad == NULL)
    return;
  if (ad->host_desc != NULL)
    freeHostDesc(ad->host_desc);
  free(ad);
}

/*
 * compAgentDescKey()
 *
 * Used for the linked list
 */
int compAgentDescKey(void *key,void *d)
{
  NS_IPaddr_type IPaddr;
  
  if (key == NULL)
    return 1;

  IPaddr = ((NS_AgentDesc *)d)->host_desc->IPaddr;

  if (*((NS_IPaddr_type *)key) == IPaddr)
    return 1;

  return 0;
}

/*
 * newAgentDesc()
 */ 
NS_AgentDesc *newAgentDesc()
{
  return (NS_AgentDesc *)calloc(1,sizeof(NS_AgentDesc));
}

/*
 * recvAgentDesc()
 *
 * Receives an Agent descriptor from a Communicator
 */
NS_AgentDesc *recvAgentDesc(NS_Communicator *comm)
{
  NS_AgentDesc *new;

  new = newAgentDesc();

  new->host_desc = recvHostDesc(comm);
  if (new->host_desc == NULL)
    return NULL;
  if (recvInt(comm,&(new->port)) == -1)
    return NULL;
  return new;
}

/*
 * sendAgentDesc()
 *
 * Sends an Agent descriptor on a Communicator
 */
int sendAgentDesc(NS_Communicator *comm, NS_AgentDesc *sd)
{
  if (sd == NULL)
  {
    ns_errno = NetSolveInternalError; 
    return -1;
  }
  if (sendHostDesc(comm,sd->host_desc) == -1)
    return -1;
  if (sendInt(comm,sd->port) == -1)
    return -1;
  return 1;
}



/*
 * agentOrder()
 */
#ifdef sunos
int agentOrder(void *s1, void *s2)
#else
int agentOrder(const void *s1, const void *s2)
#endif
{
  NS_AgentDesc **pd1 = (NS_AgentDesc **)s1;
  NS_AgentDesc **pd2 = (NS_AgentDesc **)s2;

  if (strcmp((*pd1)->host_desc->hostname,(*pd2)->host_desc->hostname) > 0)
    return 1;
  if (strcmp((*pd1)->host_desc->hostname,(*pd2)->host_desc->hostname) < 0)
    return -1;
  return 0;
}

