/*****************************************************************/
/*      process_all_problems.c                                   */
/*      Version 1.0                      Henri Casanova          */
/*****************************************************************/

#include "core.h"
#include "codegenerator.h"
#include "mnemonics.h"
#include "expressions.h"
#include "netsolveutil.h"

/*
 * processAllProblems()
 */

int processAllProblems(NS_DescFileAttributes **attr, char *shortfile, char* fullname)
{
  NS_DescFileAttributes *new;
  int i;
  int nb_pbs;
  char *tmp_names[512];
  char command[256];

  nb_pbs = splitFile(tmp_names,fullname);
  if (nb_pbs == -1)
    return -1;
  if (nb_pbs == 0)
  {
    fprintf(stderr,"File does not contain any problem description\n");
    return -1;
  }


  new = (NS_DescFileAttributes *)calloc(1,sizeof(NS_DescFileAttributes));
  new->nb_pbs = nb_pbs;
  new->pds = (NS_ProblemDesc **)calloc(nb_pbs,sizeof(NS_ProblemDesc*));
  new->pdadds = (NS_ProblemDescAddendum **)calloc(nb_pbs,sizeof(NS_ProblemDescAddendum*));

  for (i=0;i<nb_pbs;i++)
  {
    if (processProblem(&(new->pds[i]),&(new->pdadds[i]),
           tmp_names[i],shortfile) == -1)
    {
      sprintf(command,"rm -f %s",tmp_names[i]);
      system(command);
      return -1;
    }
    sprintf(command,"rm -f %s",tmp_names[i]);
    system(command);
    free(tmp_names[i]);
  }
 
  *attr = new;
  return 1;
}
