/*****************************************************************/
/*      code_generator.c                                         */
/*      Version 1.0                      Henri Casanova          */
/*****************************************************************/

#include "core.h"
#include "codegenerator.h"
#include "mnemonics.h"
#include "expressions.h"
#include "netsolveutil.h"

/*
 *  MAIN PROCEDURE
 */

int main(int argc,char **argv)
{
  char *files[512];
  char *fullfiles[512];
  char *shortfiles[512];
  char buffer[512];
  NS_DescFileAttributes *attr[512];
  int i,filesnumber;
  char target_name[256];
  char configfilename[256];
  char initcodefilename[256];

  /* Check he arguments */
  if ((argc != 1)&&(argc != 2))
  {
    fprintf(stderr,"Usage : %s [configuration file]\n",argv[0]);
    exit(-1);
  }

  /* Check the environment */
  if ((root = getNetSolveRoot()) == NULL)
  {
    fprintf(stderr,"The NETSOLVE_ROOT environment variable should be set\n");
    exit(-1);
  }

  /* Opening the configuration file */
  if (argc == 1)
  {
    fprintf(stderr,"Using the default configuration file\n");
    sprintf(configfilename,"%s/server_config",root);
  }
  else
    sprintf(configfilename,argv[1]);

  /* Condor ? */
  is_condor_server = isCondorServer(configfilename);

  /* Opening the init source file */
  sprintf(initcodefilename,"%s/src/Server/%s",root,TARGETINITCODE);
  initcodefile = fopen(initcodefilename,"w");
  if (initcodefile == NULL)
  {
    fprintf(stderr,"Cannot open file '%s'\n",initcodefilename);
    exit(-1);
  }

  /* Putting the header in the init source file */
  putInitCodeFileHeader(initcodefile);  

  /* Gathering the problem description filenames */
  filesnumber = getDescFileNames(configfilename,files);
  if (filesnumber == -1)
    exit(-1);

  if (filesnumber == 0)
  {
     fprintf(stderr,"The configuration files does not contain problem files\n");
     exit(-1);
  }

  for (i=0;i<filesnumber;i++)
  {
    char *last_slash;

    sprintf(buffer,"%s/%s",root,files[i]);
    fullfiles[i] = strdup(buffer);    

    last_slash = strrchr(files[i],'/');
    if (last_slash == NULL)
      strcpy(buffer,files[i]);
    else
      strcpy(buffer,&(files[i][(int)(last_slash-files[i]+1)]));
    shortfiles[i] = strdup(buffer);    
  }

  /*************/
  /* MAIN LOOP */
  /*************/

  fprintf(stderr,"Generating the code ...\n");

  for (i=0;i<filesnumber;i++)
  {
    fprintf(stderr,"Processing file '%s'\n",files[i]);

    /* Open the target file */
    sprintf(target_name,"%s/src/Server/%s-%s.c",root,TARGET,shortfiles[i]);
    targetfile = fopen(target_name,"w");
    if (targetfile == NULL)
    {
      fprintf(stderr,"Impossible to open the target file : %s\n",target_name);
      exit(-1);
    }

    /* Put the header */
    if (putTargetHeader() <0)
      exit(-1);

    if (processAllProblems(&(attr[i]),shortfiles[i],fullfiles[i]) == -1)
      exit(-1);
    write_line("\n\n\nreturn NS_PROT_SOLVED;\n}\n");
    if (reduceAttributes(attr[i]) == -1)
      exit(-1);
    fclose(targetfile);
    
    /* add the included files */
    if (addIncludes(target_name,attr[i]) == -1)
      return -1;
  }
 
  /* Create the def file */
  if (createDefFile(attr,filesnumber) == -1)
    exit(-1);

  fprintf(stderr,"Code generated\n");
  fprintf(stderr,"Generating the Makefile...\n"); 
  if (generateMakefile(filesnumber,files,shortfiles,attr) == -1)
    exit(-1);
  fprintf(stderr,"Makefile generated\n");

  /* Putting the tail of the problem init source file */
  fprintf(initcodefile,"  return 1;\n");
  fprintf(initcodefile,"}\n");
  fclose(initcodefile);
  exit(0);
}
  

