/*****************************************************************/
/*      waitrequest.c                                            */
/*      Henri Casanova                                           */
/*      Dieter Bachmann                                          */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "cfortranclient.h"
#include "client2proxy.h"
#include "client2server.h"
#include <unistd.h>
#include <signal.h>

/*
 * netsolveWaitRequest()
 * 
 * This function waits for the completion of a request and automatically
 * resubmit the job in case of an error.
 */
int netsolveWaitRequest_sequence(NS_Node *top_node, NS_RequestDesc **rd,int *elapsed)
{
  int status;
  NS_RequestDesc *newrd;

  status = CP_awaitJobCompletion(*rd);

  if (status == -1)
  {
    /* Resubmit */
    if (ns_errno == NetSolveInvalidRequestID)
    {
      *rd = NULL;
      *elapsed = 0;
      return -1;
    }
    reportFailure((*rd)->IPaddr, (*rd)->pd->nickname,
                  (*rd)->request_id,SERVER_ERROR);
    newrd = netsolve_sequence_SendRequest(top_node);
    free(*rd);
    *rd = newrd;
    if (*rd == NULL)
      return -1;
    return netsolveWaitRequest(NS_NOASSIGNMENT,rd,elapsed);
  }

   
  if (CS_downloadOutput_sequence(top_node, *rd,elapsed) == -1)
  { 
    switch (ns_errno) 
    {
      case NetSolveBadValues:
        return -1;
      case NetSolveDimensionMismatch:
        return -1;
      case NetSolveNoSolution:
        return -1;
    }
    /* Resubmit */
    reportFailure((*rd)->IPaddr,(*rd)->pd->nickname,
                  (*rd)->request_id,HOST_ERROR);
    newrd = netsolve_sequence_SendRequest(top_node);
    free(*rd);
    *rd = newrd;
    if (*rd == NULL)
      return -1;
    return netsolveWaitRequest_sequence(top_node, rd, elapsed); 
  }

  CP_reportJobCompleted((*rd)->IPaddr,(*rd)->request_id);

  ns_errno = NetSolveOK;
  return 1; 
} /* int netsolveWaitRequest_sequence(NS_Node *top_node, RequestDesc **rd,int *elapsed) */


