/*****************************************************************/
/*      waitrequest.c                                            */
/*      Henri Casanova, Dorian Arnold                            */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"
#include "client2server.h"
#include <unistd.h>
#include <signal.h>

/*
 * netsolveWaitRequest()
 * 
 * This function waits for the completion of a request and automatically
 * resubmit the job in case of an error unless there was a "job
 * assignment."
 */
int netsolveWaitRequest(int assignment, NS_RequestDesc **rd,int *elapsed)
{
  int status;
  NS_RequestDesc *newrd;

  status = CP_awaitJobCompletion(*rd);

  if (status == -1) {
    reportFailure((*rd)->IPaddr, (*rd)->pd->nickname,
                  (*rd)->request_id,SERVER_ERROR);
    ns_errno = NetSolveServerError;
    return -1; 
  }
#if defined (VIEW)
      fprintf(STDERR "Downloading Output from Server %s\n", (*rd)->hostname);
#endif
  if (CS_downloadOutput(*rd,elapsed) == -1) { 
    reportFailure((*rd)->IPaddr,(*rd)->pd->nickname,
                  (*rd)->request_id,HOST_ERROR);

    if(assignment){
      return -1;
    }
    else{ /* Resubmit */
      switch (ns_errno) 
      {
        case NetSolveBadValues:
          return -1;
        case NetSolveDimensionMismatch:
          return -1;
        case NetSolveNoSolution:
          return -1;
      }
      newrd = netsolveSendRequest(assignment, NULL, (*rd)->pd,(*rd)->input,(*rd)->output);
      free(*rd);
      *rd = newrd;
      if (*rd == NULL)
        return -1;
      return netsolveWaitRequest(assignment,rd,elapsed);
    }
  }

  CP_reportJobCompleted((*rd)->IPaddr,(*rd)->request_id);

  ns_errno = NetSolveOK;
  return 1; 
}
