/*****************************************************************/
/*      submit_problem.c                                         */
/*      Henri Casanova, Dorian Arnold                            */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "cfortranclient.h"

/*
 * submit_problem, formerly netsolveBlocking()
 *
 * This function allows the user to perform either a synchronous
 * or asychronous computation.
 * It returns either an error code, or with the result in the user's
 * workspace. This function is build on top of two other functions
 * that are also part of the client interfaceimplemented in this
 * directory.
 */
int submit_problem(int blocking, int assignment, char *
                   serverhostname, NS_ProblemDesc *pd,
                   NS_Object **input, NS_Object **output, int *elapsed, int request_id)
{
  int status;
  NS_RequestDesc *rd;

  /***********************************/
  /* Sending an asynchronous request */
  /***********************************/

  rd = netsolveSendRequest(assignment, serverhostname, pd,input,output);
  if(rd == NULL){
    netsolvePerror("netsolveSendRequest");
    return -1;
  }

  /*****************************************/
  /* If Blocking, Waiting for that request */
  /*****************************************/
  if(blocking == NS_BLOCK){
    status = netsolveWaitRequest(assignment, &rd,elapsed);
    free(rd);
    return status;
  }
  else{
    rd->assignment = assignment;
    requests[request_id] = rd;
    return NetSolveOK;
  }
}
