/*****************************************************************/
/*      proberequest.c                                           */
/*      Henri Casanova, Dorian Arnold                            */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"
#include <signal.h>

/*
 * netsolveProbeRequest()
 * 
 * This functions probes a user request and performs resubmission
 * in case of failure (unlike netsolveProbeAssignment().
 */
int netsolveProbeRequest(int assignment, NS_RequestDesc **rd)
{
  int status;
  NS_RequestDesc *newrd;

  /*****************/
  /* Probe the job */
  /*****************/

  status = CP_probeJob(*rd);

  /***********/
  /* Error ? */
  /***********/

  if (status == -1)
  {
    /* Just not ready ? */
    if (ns_errno == NetSolveNotReady)
      return -1;

    reportFailure((*rd)->IPaddr,(*rd)->pd->nickname,
                  (*rd)->request_id,HOST_ERROR);

    if(!assignment){  /* Resubmit */
      newrd = netsolveSendRequest(assignment, NULL, (*rd)->pd,(*rd)->input,(*rd)->output);
      free(*rd);
      *rd = newrd;
      if (*rd == NULL){
        return -1;
      }

      /***********************************************************/
      /* The user just thinks that the request is still pending, */
      /* but in fact, a new one has been sent. To achieve this   */
      /* this function has to take a RequestDesc** as input      */
      /* (as opposed to a RequestDesc*).                         */
      /***********************************************************/

      ns_errno = NetSolveNotReady;
      return -1;
    }
  }

  return 1;
}
