/*****************************************************************/
/*      major.c                                                  */
/*      Henri Casanova                                           */
/*****************************************************************/

#include "core.h"
#include "client.h"

/**
 ** GLOBAL VARIABLE
 **/

int major_set_by_the_user = 0;

/*
 * setMajor()
 *
 * This routine sets the major (row- or column-wise) used
 * by the client. Takes as input "[Rr]*" or "[Cc]*"
 */
int setMajor(char *maj)
{
  if ((maj[0]=='R')||(maj[0]=='r'))
  {
    my_major = ROW_MAJOR;
    major_set_by_the_user = 1;
  }
  else if ((maj[0]=='C')||(maj[0]=='c'))
  {
    my_major = COL_MAJOR;
    major_set_by_the_user = 1;
  }
  else
  {
    ns_errno = NetSolveInvalidMajor;
    return -1;
  }
  ns_errno = NetSolveOK;
  return 1;
}

/*
 * SetMajorDefault()
 *
 * Sets the default major. This routine is not called explicitely
 * by the user but is called automatically by the user interfaces. The
 * user can of course override the default as suitable (by the use
 * of the SetMajor() function).
 */
int setMajorDefault(char *maj)
{
  if (!major_set_by_the_user)
    return setMajor(maj);
  else
  {
    ns_errno = NetSolveOK;
    return 1;
  }
}
