/*****************************************************************/
/*      determinesizes.c                                         */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"

#ifndef WIN32
#include <unistd.h>
#include <sys/socket.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>

/*
 * determineSizes()
 *
 * Given a problem descriptor and pointers to user objects,
 * this function computes the size in bytes of the data to
 * be sent to the server (input_size), the size in bytes of 
 * the data to download from the server (output_size), and the
 * "problem size" which is a measure of the problem's compexity
 * (e.g. the size of the largest matrix among the input objects).
 */
int determineSizes(NS_ProblemDesc *pd,NS_Object **input,NS_Object **output,
      int *input_size,int *output_size, int *problem_size)
{
  int i;
  int tmp;

  /************************************************/
  /* Determine the byte size of the input objects */
  /************************************************/

  *input_size = 0;
  for (i=0;i<pd->nb_input_objects;i++)
  {
    tmp = getObjectByteSize(input[i]);
    if (tmp == -1)
      return -1;
    (*input_size) += tmp;
  }

  /*************************************************/
  /* Determine the byte size of the output objects */
  /*************************************************/

  *output_size = 0;
  for (i=0;i<pd->nb_output_objects;i++)
  {
    tmp = getObjectByteSize(output[i]);
    if (tmp == -1)
      return -1;
    (*output_size) += tmp;
  }

  /********************************************/
  /* Determine the complexity for the problem */
  /********************************************/

  *problem_size = 1;
  for (i=0;i<pd->nb_input_objects;i++)
  {
     if (input[i]->object_type == NETSOLVE_MATRIX)
     {
        *problem_size = 
            MAX(*problem_size,input[i]->attributes.matrix_attributes.m);
        *problem_size = 
            MAX(*problem_size,input[i]->attributes.matrix_attributes.n);
     }
  }

  if (*problem_size == 1){
    for (i=0;i<pd->nb_input_objects;i++)
    {
       if (input[i]->object_type == NETSOLVE_SPARSEMATRIX)
       {
          *problem_size =
              MAX(*problem_size,input[i]->attributes.sparsematrix_attributes.f);
       }
    }
  }

  if (*problem_size == 1)
  {
    for (i=0;i<pd->nb_input_objects;i++)
    {
       if (input[i]->object_type == NETSOLVE_VECTOR)
          *problem_size = 
              MAX(*problem_size,input[i]->attributes.vector_attributes.m);
    }
  }

  ns_errno = NetSolveOK;
  return 1;
}
