/*****************************************************************/
/*      calling_sequence.c                                       */
/*      Version 1.0                      Henri Casanova          */
/*      Version 1.4                      Dorian Arnold           */
/*****************************************************************/

#include <stdarg.h>
#include "core.h"
#include "mnemonics.h"
#include "expressions.h"
#include "callingsequence.h"
#include "cfortranclient.h"

/*
 * assignConstantValues()
 */

int assignConstantValues(NS_ProblemDesc *pd,NS_Object **input,NS_Object **output)
{
  int value;
  int i;

  for (i=0;i<pd->calling_sequence->nb_constants;i++)
  {
    value = atoi(pd->calling_sequence->constants[i].value);
    assignValue(pd,input,output,pd->calling_sequence->constants[i].mnemonic,&value); 
  }
  return 0;
}

/*
 * assignFormulaValues()
 */
int assignFormulaValues(NS_ProblemDesc *pd,NS_Object **input,NS_Object **output)
{
  int value;
  int i;

  for (i=0;i<pd->calling_sequence->nb_formulae;i++)
  {
    value = evalFormula(pd,pd->calling_sequence->formulae[i].expression);
    assignValue(pd,input,output,pd->calling_sequence->formulae[i].mnemonic,&value);
  }
  return 0;
}

/*
 * stacktoObject()
 * Replaces stacktoArray() and ArraytoObject() calls in prior versions
 *
 * Takes the vararg list from C or Fortran and converts
 * it into the "NetSolve Input and Output Objects"
 *
 */

int StackToObjects(int language, NS_ProblemDesc *pd, va_list argptr,
                  NS_Object **input,NS_Object **output)
{
  int i;
  NS_VoidStarOrInt *arg_array;
  char *mnemoniclist, *mnemonic;
  int arg_type;
  void *arg_value=NULL;
  char *char_ptr[256];
  int string_len[256];
  int arg_index_for_char_ptr[256];
  int char_ptr_index = 0;

  arg_array = (NS_VoidStarOrInt *)calloc
              (pd->calling_sequence->nb_args,sizeof(NS_VoidStarOrInt));

#if defined(DEBUG)
  ns_printinfo();
  fprintf(stderr, "There are %d arguments in the calling sequence\n",
          pd->calling_sequence->nb_args);
#endif
  for(i=0; i<pd->calling_sequence->nb_args; i++)
  {
    mnemoniclist = strdup(pd->calling_sequence->arg_to_mnemonic[i]);
#if defined(DEBUG)
    ns_printinfo();
    fprintf(stderr, "The mnemoniclist for argument %d is %s\n", i,
            mnemoniclist);
#endif
    arg_type = getArgumentType(mnemoniclist);

    switch (arg_type){
    case IGNORE:
#if defined(DEBUG)
      ns_printinfo();
      fprintf(stderr, "Argument[%d] is ignored\n", i);
#endif
      /* WARNING : Strings cannot be ignored. It DOES NOT WORK !!! */
      arg_array[i].ptr = (void *)va_arg(argptr, void*);
      arg_array[i].ptr = NULL;
      free(mnemoniclist);
      continue;
      break;

    case INTEGER:
      if (language == NS_CALL_FROM_FORTRAN){
        int *tmp = (int *)va_arg(argptr, int*);
        arg_array[i].i = *tmp;
      }
      else {
        arg_array[i].i = (int)va_arg(argptr, int);
      }
#if defined(DEBUG)
      ns_printinfo();
      fprintf(stderr, "Argument[%d] is an int of value: %d\n", i,
              arg_array[i].i);
#endif
      break;

    case POINTER:
      arg_array[i].ptr = (void *)va_arg(argptr, void*);
#if defined(DEBUG)
      ns_printinfo();
      fprintf(stderr, "Argument[%d] is an ptr of value: 0x%x\n", i,
              (int)arg_array[i].ptr);
#endif
      break;
    }

    if((language == NS_CALL_FROM_FORTRAN) &&
       (isStringArgument(pd, mnemoniclist) != 0)){

#if defined(DEBUG)
      ns_printinfo();
      fprintf(stderr, "Oh oh, current argument is a fortran "
                      "string\n");
#endif
      /* Ok, it's a string..... sigh .... */
      char_ptr[char_ptr_index] = (char*)arg_array[i].ptr;
      arg_index_for_char_ptr[char_ptr_index] = i;
#if defined(F2CSTRCRAYSTYLE)
      string_len[char_ptr_index] = ((int)va_arg(argptr,int));
#endif
      char_ptr_index++;
    }

    free(mnemoniclist);
  } /* end for loop (0 to nb_args) */

  if (language == NS_CALL_FROM_FORTRAN)
  {
    char *new_string;
#if defined(F2CSTRSUNSTYLE)
    /* int shadow; */
    /* Get all the strlen */

    /* Pop the length of the problem nickname */
    (void)va_arg(argptr,int);
    for (i=0;i<char_ptr_index;i++)
    {
      string_len[i] = (int)va_arg(argptr,int);
    }
#endif

    /* replace the regular string with NULL terminated ones */
#if defined(DEBUG)
    ns_printinfo();
    fprintf(stderr, "NULL Terminating Fortran Strings ... \n");
#endif
    for (i=0;i<char_ptr_index;i++)
    {
      new_string = (char*)calloc(string_len[i]+1,sizeof(char));
      strncpy(new_string,char_ptr[i],string_len[i]);
      arg_array[arg_index_for_char_ptr[i]].ptr = new_string;
#if defined(DEBUG)
      ns_printinfo();
      fprintf(stderr, "String argument %d: %s\n", i, new_string);
#endif
    }
  }
  
  /* Putting the values in the objects */
  for (i=0;i<pd->calling_sequence->nb_args;i++)
  {
    mnemoniclist = strdup(pd->calling_sequence->arg_to_mnemonic[i]);
    arg_type = getArgumentType(mnemoniclist);

    if (arg_type == IGNORE)
    {
      free(mnemoniclist);
      continue;
    }
    if (arg_type == INTEGER)
      arg_value = (void*)(&(arg_array[i].i));
    if (arg_type == POINTER)
      arg_value = arg_array[i].ptr;

    mnemonic = strtok(mnemoniclist," \t,\0");
    while(mnemonic != NULL)
    {
      assignValue(pd,input,output,mnemonic,arg_value);

      mnemonic = (char *)strtok(NULL,"\t ,");
    }
    free(mnemoniclist); 
  }
  
  return 0;
}

/*
 * arrayToObjects()
 *
 * Use the array generated by the function above to
 * fill in the objects.
 * Note: Now only called from farming interface
 */

int arrayToObjects(int language, NS_ProblemDesc *pd,
            NS_Object **input,NS_Object **output,NS_VoidStarOrInt *array)
{
  int i;
  char *mnemoniclist;
  int arg_type;
  void *arg_value=NULL;
  char *mnemonic;

  /* Putting the values in the objects */
  for (i=0;i<pd->calling_sequence->nb_args;i++)
  {
    mnemoniclist = strdup(pd->calling_sequence->arg_to_mnemonic[i]);
    arg_type = getArgumentType(mnemoniclist);

    if (arg_type == IGNORE)
    {
      free(mnemoniclist);
      continue;
    }
    if (arg_type == INTEGER)
      arg_value = (void*)(&(array[i].i));
    if (arg_type == POINTER)
      arg_value = array[i].ptr;

    mnemonic = strtok(mnemoniclist," \t,\0");
    while(mnemonic != NULL)
    {
      if (language == NS_CALL_FROM_FORTRAN)
      {
        int index;
        index = getIndex(mnemonic);
        if (getIO(mnemonic) == OUTPUT)
        {
          if (output[index]->object_type == NETSOLVE_STRING)
            output[index]->attributes.string_attributes.ptr = arg_value;
          else
            assignValue(pd,input,output,mnemonic,arg_value);
        }
        else
        {
          if (input[index]->object_type == NETSOLVE_STRING)
            assignValue(pd,input,output,mnemonic,strdup((char*)arg_value));          else
            assignValue(pd,input,output,mnemonic,arg_value);
        }
      }
      else
        assignValue(pd,input,output,mnemonic,arg_value);
      mnemonic = (char *)strtok(NULL,"\t ,");
    }
    free(mnemoniclist);
  }
  return 0;
}
