/*****************************************************************/
/*      CP_sendjobrequest_sequence.c                             */
/*      Henri Casanova                                           */
/*      Dieter Bachmann                                          */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#include <signal.h>
#include <time.h>

/*
 *  CP_sendjobrequest_sequence()
 *
 */
NS_RequestDesc *CP_sendJobRequest_sequence(NS_Node* top_node)
{
  NS_RequestDesc *rd;
  NS_Communicator *comm;
  int port;
  unsigned int IPaddr;
  int data_format;
  char *hostname;
  int NS_errno;


  /********************************************/
  /* contact the proxy 			      */
  /********************************************/
  comm = contactProxy(1);
  if (comm == NULL)
  {
    netsolvePerror("contactProxy()");
    ns_errno = NetSolveProxyError;
    return NULL;
  } 

  /* Sending protocol and  nodes */
  if ((sendInt(comm,NS_PROT_SEND_SEQUENCE_REQUEST) == -1) ||
      (netsl_send_Nodes(comm, top_node) == -1))
  {
    netsolvePerror("netsl_send_Nodes()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  if (recvInt(comm,&NS_errno) == -1)
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  } 


  if (NS_errno != NetSolveOK) /* ERROR */
  {
    endTransaction(comm);
    ns_errno = NS_errno;
    return NULL;
  }

  rd = newRequestDesc();
  if (rd == NULL) {
    endTransaction(comm);
    ns_errno = NS_errno;  /* XXX: better error code ? */
    return NULL;   
  }
  rd->pd = top_node->pd;

  /* Receive the proxy request_id */
  if ((recvInt(comm,&(rd->request_id)) == -1) ||
     (recvInt(comm,&(rd->predicted_time)) == -1) ||
     (recvInt(comm,&(rd->start_time)) == -1))
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  /* receive the location of the server */
  if ((recvIPaddr(comm,&IPaddr) == -1) ||
      (recvString(comm,&hostname) == -1) ||
      (recvInt(comm,&port) == -1) ||
      (recvInt(comm,&data_format) == -1))
  {
    netsolvePerror("");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }
  rd->hostname = hostname;
  rd->IPaddr = IPaddr;
  rd->port = port;
  if (data_format == my_data_format)
    rd->encoding = DATA_RAW;
  else 
    rd->encoding = DATA_XDR;

  endTransaction(comm);
  ns_errno = NetSolveOK;
  return rd;
} /*RequestDesc *CP_sendJobRequest_sequence(NS_Node* top_node) */

