/*****************************************************************/
/*      CP_reportrequestcompleted.c                              */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#include <sys/socket.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>


/*
 *  CP_reportJobCompleted()
 */
void CP_reportJobCompleted(NS_IPaddr_type IPaddr, int ID)
{
  NS_Communicator *comm;
 
  /* contact the proxy */
  comm = contactProxy(1);
  if (comm == NULL)
  {
    netsolvePerror("contactProxy()");
    ns_errno = NetSolveProxyError;
    return;
  }

  if ((sendInt(comm,NS_PROT_JOB_COMPLETED) == -1) ||
      (sendIPaddr(comm,&IPaddr) == -1) ||
      (sendInt(comm,ID) == -1))
  {
    endTransaction(comm);
    netsolvePerror("");
    ns_errno = NetSolveProxyError;
    return;
  }
  endTransaction(comm);
  return;
}
