/*****************************************************************/
/*      CP_waitjob.c                                             */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"
#include <signal.h>
#include <time.h>

/*
 *  CP_probeJob()
 *
 */
int CP_probeJob(NS_RequestDesc *rd)
{
  int error_code;
  NS_Communicator *comm;
  int NS_errno;

  /********************************************/
  /* contact the proxy 			      */
  /********************************************/
  comm = contactProxy(1);
  if (comm == NULL)
  {
    netsolvePerror("contactProxy()");
    ns_errno = NetSolveProxyError;
    return -1;
  } 

  /* Sending */
  if ((sendInt(comm,NS_PROT_PROBE_REQUEST) == -1)  ||
      (sendInt(comm,rd->request_id) == -1))
  {
    netsolvePerror("sendInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Receiving */
  if (recvInt(comm,&NS_errno) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  } 
  if (NS_errno != NetSolveOK)
  {
    endTransaction(comm);
    ns_errno = NS_errno;
    return -1;
  }

  if (recvInt(comm,&error_code) == -1) /* The actual job status */
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }
  endTransaction(comm);

  ns_errno = error_code;
  if (ns_errno == NetSolveOK)
    return 0;

  return -1;
}
