/*****************************************************************/
/*      CP_killjob.c                                             */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"
#include "proxyjobdesc.h"
#include "proxy.h"

#include <signal.h>
#include <time.h>

/*
 *  CP_killJob()
 *
 */
int CP_killJob(NS_RequestDesc *rd)
{
  NS_Communicator *comm;
  int NS_errno;

  /********************************************/
  /* contact the proxy 			      */
  /********************************************/
  comm = contactProxy(1);
  if (comm == NULL)
  {
    netsolvePerror("contactProxy()");
    ns_errno = NetSolveProxyError;
    return -1;
  } 

  /* Sending */
  if ((sendInt(comm,NS_PROT_KILL_JOB) == -1)              ||
      (sendInt(comm,rd->request_id) == -1))
  {
    netsolvePerror("sendInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Receiving */
  if (recvInt(comm,&NS_errno) == -1)
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }

  endTransaction(comm);

  ns_errno = NS_errno;
  if (ns_errno == NetSolveOK)
    return 1;
  else
    return -1;
}
