/*****************************************************************/
/*      sequences.c                                              */
/*      Version 1.0                      Dieter Bachmann         */
/*---------------------------------------------------------------*/
/*   user interface 
void    netsl_sequence_begin();     begin of bracket 
int     netsl_sequence_end();       end of sequence, schedule jobs 

status functions 
int     netsl_sequence_status();    collecting calls? TRUE/FALSE 

Node-list manipulation 

NS_Node* netsl_get_Sequence();       get pointer to top/root Node 

                                                   
******************************************************************/

#include "client.h"
#include "netsolveclient.h"
#include "netsolve.h"
#include "clientglobal.h"

/* 
 * Undefine the following to debug DAG generation
 *
 * #define GRAPH_DEBUG
 */

/* user interface */
void    netsl_sequence_begin(){     /* begin of bracket */ 

  if(!proxy_pid){  /*proxy needs to be started*/
    if(netslinit(NULL) < 0){
      /* mm- generates compile error  return ns_errno; */
      ns_errno = NetSolveCannotStartProxy;
      return;
    }
  }

  printf("Begin NetSolve bracket\n");
  NS_SequenceMode = TRUE;
} /* netsl_sequence_begin() */




/* extract the pointer to the data from an object (handle the union) */
/* only VECTOR and MATRIX */
void* netsl_get_Object_Pointer(NS_Object* in_object){
    
  switch (in_object->object_type){  
  case NETSOLVE_VECTOR:  
      return in_object->attributes.vector_attributes.ptr;
  case NETSOLVE_MATRIX: 
      return in_object->attributes.matrix_attributes.ptr;
  case NETSOLVE_SPARSEMATRIX: 
      return in_object->attributes.sparsematrix_attributes.ptr;
  } /* case  */
   

  return NULL;

}

/* compare object pointers, types,... to check if two objects are equal */
int netsl_compare_Objects(NS_Object* in1, NS_Object* in2){

void * tmp_ptr;
tmp_ptr = netsl_get_Object_Pointer(in1);

 if ((tmp_ptr != NULL) &&    /* not empty */
     ( netsl_get_Object_Pointer(in2) == tmp_ptr))  /* pointers are equal */
     /*&& (in1->object_type == in2->object_type))  */   /*types are equal */
     /* && add a size check here ! */
     return TRUE;

 return FALSE;   /* else not equal */
} /* netsl_compre_objects */





/* mark all outputs with address tmp_ptr not to pass back */

int get_output_id (void* tmp_ptr, NS_Node* top_node){

    NS_Node* tmp_node;
    int   i;


 tmp_node = top_node;
 if (tmp_node == NULL) {
     fprintf(stderr,"The actual sequence is empty!\n");
     return FALSE;
 }

 while (tmp_node != NULL){ /* for all nodes */
    for (i = 0; i< tmp_node->pd->nb_output_objects; i++){  /* for all outputs in tmp_node (forward)*/
	
	if ( (netsl_get_Object_Pointer( tmp_node->pd->output_objects[i])) == tmp_ptr){
	    tmp_node->pd->output_objects[i]->pass_back = FALSE;   /* don't pass it back */
	}/* if */
	
    } /* for */
     
     tmp_node = tmp_node->next;
  } /* while (tmp_node != NULL) */

 return TRUE;

}  /* get_output_id */



/* Node-list manipulation */
NS_Node** netsl_get_Sequence(){       /* get pointer to top/root Node */
  return &NS_Sequence;
} /* netsl_get_Sequence() */



/* end of sequence, schedule jobs */
int     netsl_sequence_end(void* tmpptr, ...){       

    va_list agptr;
    int     num_args;
    int     i;
    void   **tmp_ptr;
    int     elapsed;
    int     status;
    NS_Node *tmp_node;
    NS_Node **tmp_node_ptr;

    /* vararg parsing */
    /**************************************************/
    /* num_args = va_arg(argptr, int); */

    tmp_ptr = malloc (100 * sizeof (void*));  /* size is const 100 args */

    

    num_args =0;
    va_start(agptr,tmpptr);
    tmp_ptr[0]= tmpptr;

    while (tmp_ptr[num_args]  != &NS_EndArg) {
	num_args++; /* get the number of parameters */ 
        tmp_ptr[num_args] = va_arg(agptr, void*);
    }


    va_end(agptr); 



    for(i = 0; i < num_args; i++){
	/* locate the dependency */
	/* an only be an output */
	if (get_output_id (tmp_ptr[i], *netsl_get_Sequence()) == FALSE) {
	    fprintf(stderr,"pointer number %d not used in the sequence!\n",i);
	}

    }


  /****** execute sequence ************/

  printf("End bracket - scheduling sequence\n");

  NS_SequenceMode = FALSE;   /* sequence-mode = false */  

  status = netsolve_sequence_Blocking(*netsl_get_Sequence(),&elapsed);

  /****** output handling *************/


    if (status != -1)
    {
      /* take care of the strings in output */
	tmp_node = *netsl_get_Sequence();
	while(tmp_node!=NULL){

	    for (i=0; i<tmp_node->pd->nb_output_objects; i++)
		{
		    if (tmp_node->pd->output_objects[i]->pass_back == FALSE) continue;
		    if (tmp_node->pd->output_objects[i]->object_type != NETSOLVE_STRING)
			continue;
		    strcpy(tmp_node->tmp_output_ptr[i],
			   tmp_node->pd->output_objects[i]->attributes.string_attributes.ptr);
		    free(tmp_node->pd->output_objects[i]->attributes.string_attributes.ptr);
		}
	    tmp_node=tmp_node->next;
	}
	ns_errno = NetSolveOK;

    }

  /****** cleanup *********************/

    netsl_delete_Nodes(*netsl_get_Sequence());
    free (tmp_ptr);
    tmp_node_ptr = netsl_get_Sequence();
    *tmp_node_ptr = NULL;
    
    return ns_errno;

}
/* status functions */
int     netsl_sequence_status(){    /* collecting calls? TRUE/FALSE */
  return NS_SequenceMode;
} /* netsl_sequence_status() */ 




/* Analyze dependencies */
/* all 4 kinds are checked here RW, RR, WR, WW) */
int netsl_analyze_Graph(NS_Node *bottom_node, NS_Node *top_node){

  NS_Node *tmp_node;
  int      i;         /* loops */
  int      j;         /* loops */


  if ((bottom_node == NULL) || (top_node == NULL)){
      /*    fprintf(stderr, "Wrong node setup!\n"); */
    return FALSE;
  } /* if nodes are empty */ 


#ifdef GRAPH_DEBUG
  fprintf(stderr, "Analyzing DAG for node id=%d (%s)\n",
	  bottom_node->id, bottom_node->pd->nickname);
#endif

  /* INPUT checks */


  /* RR - dependency */
  /* check actual node (inputs) against actual node (inputs) */
  /* two forward loops */
  /* if two inputs are equal, the second one is just a local link */

  tmp_node = bottom_node; /* local checks */
       
  for (i = 0; i<tmp_node->pd->nb_input_objects; i++){  /* for all inputs in tmp_node (forward)*/

      for(j = 0; j < i; j++){ /* check all inputs */

	  /* Matrixes and vectors use different structures input and output! */

	  if ((netsl_compare_Objects(bottom_node->pd->input_objects[j],tmp_node->pd->input_objects[i])) && 
	      (bottom_node->in_dep->dep_type[j] == NETSOLVE_NO_DEPENDENCY)) { /* setup link */
 	          bottom_node->in_dep->dep_type[i] = NETSOLVE_LOCAL_DEPENDENCY;
		  bottom_node->in_dep->dest_node[i] = tmp_node->id;
		  bottom_node->in_dep->dest_arg[i] = j;
		  bottom_node->pd->input_objects[i]->pass_back = FALSE;  /* don't send over the network */
#ifdef GRAPH_DEBUG
  		  fprintf(stderr,"(%s) Linked node:%d input:%d (%s) node:%d input:%d "
  			  "Type:RR-local\n", 
			  bottom_node->pd->nickname, bottom_node->id, j, 
			  tmp_node->pd->nickname, tmp_node->id, i);
#endif
	  } /* set up linik */

      } /* check all links */

  } /* for all output nodes */




  /* RW ... read after write dependency (backward)
     former outputs are checked if they have modyfied the actual input */
  
  tmp_node = bottom_node->last;

  while (tmp_node != NULL){ /* for all nodes */
  
    for (i = tmp_node->pd->nb_output_objects-1; i>=0; i--){  /* for all outputs in tmp_node (backward)*/
  

	for(j = 0; j < bottom_node->pd->nb_input_objects; j++){ /* check all inputs */

	    /* Matrixes and vectors use different structures input and output! */
 	    if ((netsl_compare_Objects(bottom_node->pd->input_objects[j],
				       tmp_node->pd->output_objects[i])) && 
		(bottom_node->in_dep->dep_type[j] == NETSOLVE_NO_DEPENDENCY)) { /* setup link */
		   bottom_node->in_dep->dep_type[j] = NETSOLVE_OUTPUT_DEPENDENCY;
		   bottom_node->in_dep->dest_node[j] = tmp_node->id;
		   bottom_node->in_dep->dest_arg[j] = i;
 		   bottom_node->pd->input_objects[j]->pass_back = FALSE;  /* don't send over the network */
#ifdef GRAPH_DEBUG
  		   fprintf(stderr,
			   "(%s) Linked node:%d input:%d (%s) node:%d output:%d " 
  			   "Type:RW-backward\n", 
			   bottom_node->pd->nickname, bottom_node->id, j, 
			   tmp_node->pd->nickname, tmp_node->id, i);
#endif
	    } /* set up linik */

	} /* check all links */

    } /* for all output nodes */


  /* RR ... read after read dependency (forward) if the data has not
     been modified by a previous method, the first occurence (input)
     stored the original data */
  /* check actual node against all other nodes */


    for (i = tmp_node->pd->nb_input_objects-1; i>=0; i--){  /* for all inputs in tmp_node (backward)*/
	for(j = 0; j < bottom_node->pd->nb_input_objects; j++){ /* check all inputs */

	    /* Matrixes and vectors use different structures input and output! */

 	    if ((netsl_compare_Objects(bottom_node->pd->input_objects[j],
				       tmp_node->pd->input_objects[i])) && 
		(bottom_node->in_dep->dep_type[j] == NETSOLVE_NO_DEPENDENCY)) { /* setup link */
  	            bottom_node->in_dep->dep_type[j] = NETSOLVE_INPUT_DEPENDENCY;
		    bottom_node->in_dep->dest_node[j] = tmp_node->id;
		    bottom_node->in_dep->dest_arg[j] = i;
		    bottom_node->pd->input_objects[j]->pass_back = FALSE;  /* don't send over the network */
#ifdef GRAPH_DEBUG
  		    fprintf(stderr,
			    "(%s) Linked node:%d input:%d (%s) node:%d input:%d " 
  			    "Type:RR-forward\n", 
			    bottom_node->pd->nickname, bottom_node->id, j,
			    tmp_node->pd->nickname, tmp_node->id, i);
#endif
	    } /* set up linik */

	} /* check all links */

    } /* for all input nodes */

  tmp_node=tmp_node->last;
  } /*  while (tmp_node != NULL) */










  /* OUTPUT checks */


   /* W/RW ... all previous methods must finish until the output may be overwritten! */




  /* WW ... write after write dependency (backward)
     former outputs are checked if they have modyfied the actual output */
  
  tmp_node = bottom_node;

  while (tmp_node != NULL){ /* for all nodes */

   if (tmp_node!=bottom_node) /* don't check outputs against outputs */
       for (i = tmp_node->pd->nb_output_objects-1; i>=0; i--){  /* for all outputs in tmp_node (backward)*/
	   
	   for(j = 0; j < bottom_node->pd->nb_output_objects; j++){ /* check all inputs */

	    /* Matrixes and vectors use different structures input and output! */

	       if ((netsl_compare_Objects(bottom_node->pd->output_objects[j],
					  tmp_node->pd->output_objects[i])) && 
		   (bottom_node->out_dep->dep_type[j] == NETSOLVE_NO_DEPENDENCY)) { /* setup link */
		   bottom_node->out_dep->dep_type[j] = NETSOLVE_OUTPUT_DEPENDENCY;
		   bottom_node->out_dep->dest_node[j] = tmp_node->id;
		   bottom_node->out_dep->dest_arg[j] = i;
		   tmp_node->pd->output_objects[i]->pass_back = FALSE;  /* don't send over the network */
#ifdef GRAPH_DEBUG
  		   fprintf(stderr,
			   "(%s) Linked node:%d output:%d (%s) node:%d output:%d " 
  			   "Type:WW-backward (output)\n", 
			   bottom_node->pd->nickname, bottom_node->id, j,
			   tmp_node->pd->nickname, tmp_node->id, i); 
#endif
	    } /* set up linik */

	} /* check all links */

    } /* for all output nodes */


   for (i = tmp_node->pd->nb_input_objects-1; i>=0; i--){  /* for all inputs in tmp_node (backward)*/

       for(j = 0; j < bottom_node->pd->nb_output_objects; j++){ /* check all inputs */

	    /* Matrixes and vectors use different structures input and output! */

	   if ((netsl_compare_Objects(bottom_node->pd->output_objects[j],
				      tmp_node->pd->input_objects[i])) && 
	       (bottom_node->out_dep->dep_type[j] == NETSOLVE_NO_DEPENDENCY)) { /* setup link */
	       bottom_node->out_dep->dep_type[j] = NETSOLVE_INPUT_DEPENDENCY;
	       bottom_node->out_dep->dest_node[j] = tmp_node->id;
	       bottom_node->out_dep->dest_arg[j] = i;
#ifdef GRAPH_DEBUG
  	       fprintf(stderr,"(%s) Linked node:%d output:%d (%s) node:%d input:%d " 
  		       "Type:WW-backward (input)\n", 
		       bottom_node->pd->nickname, bottom_node->id, j,
		       tmp_node->pd->nickname, tmp_node->id, i);
#endif
	    } /* set up linik */

	} /* check all links */

    } /* for all input nodes nodes */


  tmp_node=tmp_node->last;
  } /*  while (tmp_node != NULL) */

return TRUE;
}/* netsl_analyze_Graph(NS_Node *last_node, NS_Node *root_Node) */
