/*****************************************************************/
/*      netslpr.c                                                */
/*      Version 1.0                      Henri Casanova          */
/*****************************************************************/



/*
 * fnetslpr() : FORTRAN interface 
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "mnemonics.h"


void fnetslpr(int *request_id,int *info)
{
  int status;
  NS_RequestDesc *rd = requests[*request_id];
 
  if (rd == NULL) {
    *info = NetSolveInvalidRequestID;
    return;
  }

  status = netsolveProbeRequest(rd->assignment, &rd);

  if (ns_errno == NetSolveNotReady) {
    *info = NetSolveNotReady;
    return;
  }

  if (status == -1)
  {
    freeProblemDesc(rd->pd);
    free(output_ptrs[*request_id]);
    freeRequestDesc(rd);
    requests[*request_id] = NULL;
    output_ptrs[*request_id] = NULL;
    requests[*request_id] = NULL;
    output_ptrs[*request_id] = NULL;
  }

  *info = ns_errno;
  return;
}

