/*****************************************************************/
/*      fnetsl.c                                                 */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  fnetsl()                                                     */
/*****************************************************************/

/*
 * fnetsl() : vararg C Interface to the NetSolve Client
 */

#include <stdarg.h>
#include "netsolve.h"
#include "core.h"
#include "client.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "mnemonics.h"

void fnetsl(char *nickname,...)
{
  va_list argptr;
  char *buf;
  int *return_value, len;

  /* Getting the problem's nickname */
  va_start(argptr,nickname); 

#ifdef F2CSTRCRAYSTYLE
  va_arg(argptr,int);
#endif

  buf = nickname;
  while ((*buf != '(')&&(*buf != '\0'))
    buf++;

  len = (int)(buf - nickname+2);

  buf = (char *)calloc(len+1,sizeof(char));
  BCOPY(nickname,buf,len);
  buf[len] = '\0';

  /* Get the address of the return value */
  return_value = (int*)va_arg(argptr,int*);

  *return_value = netslX(buf, argptr, NS_CALL_FROM_FORTRAN,
                         NS_BLOCK, NS_NOASSIGNMENT);

  return;
}
