/*****************************************************************/
/*      netslkill.c                                              */
/*      Henri Casanova          				 */
/*---------------------------------------------------------------*/
/*  netslkill()                                                  */
/*****************************************************************/

/*
 * netslkill() : vararg C Interface to the NetSolve Client
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "mnemonics.h"

int netslkill(int request_id)
{
  int status;
 
  if (requests[request_id] == NULL)
    return NetSolveInvalidRequestID;

  status = netsolveKillJob(requests[request_id]);

  freeProblemDesc(requests[request_id]->pd);
  free(output_ptrs[request_id]);
  freeRequestDesc(requests[request_id]);
  requests[request_id] = NULL;
  output_ptrs[request_id] = NULL;

  return ns_errno;
}
