/*****************************************************************/
/*      netsl.c                                                  */
/*      Version 1.0                      Henri Casanova          */
/*      Version 1.3                      Dorian Arnold           */
/*---------------------------------------------------------------*/
/*  netsl()                                                      */
/*****************************************************************/

/*
 * netsl() : vararg C Interface to the NetSolve Client
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "mnemonics.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "sequences.h"
#include "netsolve.h"

int netsl(char *nickname,...)
{
  va_list argptr;
  char * buf;

  /* Getting the problem's nickname */
  va_start(argptr,nickname); 
  buf = strdup(nickname);

  return netslX(buf, argptr, NS_CALL_FROM_C, NS_BLOCK, NS_NOASSIGNMENT);
}
