/*****************************************************************/
/*      initNWSAgent.c                                           */
/*      Karine Heydeman                                          */
/*      modified by Susan Blackford, Patrick Geoffray            */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include "nwsutils.h"
#include "netsolveerror.h"

extern int errno;

int hostcompose( const char * machineName, int machinePort, char * name)
{
char port[8];

 if (strcpy(name,machineName) == NULL){ 
   return -1;
 }

 if (strncat(name,":",1) == NULL)
  {
    printf(" can't append : %s", machineName);
    return(-1);
  }

  sprintf(port,"%i",machinePort);
  if (strncat(name,port,strlen(port)) != NULL )
     return 0;
  else
     return -1;
}

int startNWSNameServer(char const *machineName)
{
int pid, ok;
struct stat buf;
char NS_Port[8];
char cmd[256];
int i;

 /* check for the status of NWS_NAMESERVER_LOG, already exist? */

 /* ok = stat(NWS_NAMESERVER_LOG, &buf);
 if ( ok == -1 ) 
   if (errno == ENOENT)
     initialtime = (time_t)0;
   else
    {
      netsolvePerror("");
      return -1;
    } 
  else
    initialtime = buf.st_mtime; */

 sprintf(cmd, "/bin/rm -f %s %s %s", NWS_NAMESERVER_LOG,
                                     NWS_NAMESERVER_ERR,
                                     NWS_REGISTRATIONS);
 system(cmd);

 pid=fork();
 if (pid !=0) /* I am the father */ 
   {
    /* poll for the status of NWS_NAMESERVER_LOG, has it been created? */
    for(i=0; i<10; i++){
      ok = stat(NWS_NAMESERVER_LOG, &buf);
       if (ok == -1){
         if (errno == ENOENT){
           sleep(1);
         }
         else{
           return -1;
         }
       }
       else{
         return pid;
       }
     }
     return -1;
   }

 sprintf(NS_Port, "%d", NWS_DEFAULT_NAMESERVER_PORT); 
 if (execlp("nws_nameserver",
        "nws_nameserver",
        "-e",
        NWS_NAMESERVER_ERR,
        "-f"
        NWS_REGISTRATIONS,
        "-l"
        NWS_NAMESERVER_LOG,
        "-p",
        NS_Port,
	    NULL) < 0 )
   fprintf(stderr,"ERROR: Unable to start NWS_nameserver on %s\n ",machineName);
   return(-1);
}

int startNWSMemory(char const *NSname, int const NSport,char *Memname)
{
int pid, ok;
struct stat buf;
char MEM_Port[8], NScomp[70], cmd[256];
int i;

 if (hostcompose(NSname,NSport,NScomp)== -1)
   {   printf(" startmemory, composition de NS ...."); return -1;}

 /* check for the status of NWS_MEMORY_LOG, already exist? */

 sprintf(cmd, "/bin/rm -f %s %s", NWS_MEMORY_LOG, NWS_MEMORY_ERR);
 system(cmd);

 pid=fork();
 if (pid !=0) /* I am the father */ 
   { 
    /* poll for the status of NWS_MEMORY_LOG, has it been created? */
      for(i=0; i<10; i++){
      ok = stat(NWS_MEMORY_LOG, &buf);
         if ( (ok == -1)){
           if (errno == ENOENT){
             sleep(1);
           }
           else{
             return -1;
           }
         }
         else{
           return pid;
         }
     }
     return -1;
   }

 sprintf(MEM_Port, "%d", NWS_DEFAULT_MEMORY_PORT); 
 if (execlp("nws_memory",
        "nws_memory",
        "-d",
        NWS_MEMORY_DIR,
	  "-e",
        NWS_MEMORY_ERR,
        "-l"
        NWS_MEMORY_LOG,
        "-N",
	 NScomp,
        "-p",
        MEM_Port,
        NULL) < 0 )
  {
    fprintf(stderr,"ERROR: Unable to start NWS_memory on %s \n",Memname);
    exit(-1);
  }
 return 0;
}



int startNWSForecaster(char const * NSname, int const NSport)
{
int pid, ok;
struct stat buf;
char FOR_Port[8], NScomp[70];
int i;
char cmd[256];

 if (hostcompose(NSname,NSport,NScomp)== -1)
   {   printf(" startfore, composition de NS ...."); return -1;}
 
 sprintf(cmd, "/bin/rm -f %s %s", NWS_FORECASTER_LOG, NWS_FORECASTER_ERR);
 system(cmd);

 pid = fork();
 if (pid !=0) /* I am the father */ 
   {
    /* poll for the status of NWS_FORECASTER_LOG, has it been created? */
     for(i=0; i<10; i++){
      ok = stat(NWS_FORECASTER_LOG, &buf);
         if ( (ok == -1)){
           if (errno == ENOENT){
             sleep(1);
           }
           else{
             return -1;
           }
         }
         else{
           return pid;
         }
     }
     return -1;
   }

 sprintf(FOR_Port, "%d", NWS_DEFAULT_FORECASTER_PORT);
 if (execlp("nws_forecast",
        "nws_forecast",
        "-e",
        NWS_FORECASTER_ERR,
        "-l"
        NWS_FORECASTER_LOG,
        "-N",
        NScomp,
        "-p",
        FOR_Port,
        NULL) < 0 )
   {
     fprintf(stderr,"ERROR: Unable to start NWS_forecast.\n");
     return(-1);
   }
 return 0;
}
