/*****************************************************************/
/*      agent.c                                                  */
/*      Henri Casanova, Dorian Arnold                            */
/*---------------------------------------------------------------*/
/*  main()                                                       */
/*****************************************************************/

#include "core.h"
#include <signal.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <unistd.h>
#include <sys/socket.h>
#include "agentglobal.h"
#include "agentinit.h"
#include "agentprocessmessage.h"
#include <time.h>
#include "infoserver.h"

/*
 *  This is the main routine. It does nothing but 
 *  calling the initialization routine and
 *  waiting for a network connection.
 */

int main(int argc,char **argv)
{
  time_t cur_time, last_check;
  NS_Socket_type sock;

  /* Initialize the agent */
  if(agent_init(argc,argv) == -1)
    exit(0);

  /* at least 2 min. delay before 1st check */
  last_check = time(0) + 60;

  listen(global.sock,MAX_CONNECTIONS);
  while(1)
  {
    if ((sock = acceptConnection(global.sock)) == -1)
      continue;

    cur_time = time(0);
    if(cur_time - last_check >= 60){
#if (defined(DEBUG) || defined(VIEW))
      fprintf(stderr, "NS: Agent checking for dead servers: %s\n", Ctime(&cur_time));
#endif
      check_servers(cur_time);
      last_check = time(0);
    }
    fflush(stderr);
    fflush(stdout);

    processMessage(sock);
    fflush(stderr);
    fflush(stdout);
  }
}
