/*****************************************************************/
/*      serverdesc.h                                             */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_SERVERDESC_H
#define __NS_SERVERDESC_H


/**
 ** MACRO DEFINITIONS
 **/
#define SERVER_DOWN 0
#define SERVER_UP   1
 
/**
 **  STRUCTURE DEFINITIONS
 **/

/*
 * ServerDesc
 *
 *  Contains all the information on a server
 */

typedef struct {
  NS_HostDesc *host_desc; 	             /* Host descriptor            */
  int port; 		             /* IP port number             */
  NS_WorkloadHistory *workload_history; /* Past workload measurements */
  NS_NetworkHistory  *network_history;  /* Past network measurements  */
  int nb_restrictions;               /* Nb of user restrictions    */
  NS_RestrictionDesc **restrictions;    /* User Access Restrictions   */
  int workload_threshhold;	     /* Workload Threshhold        */
  int broadcast;		     /* Can agents broadcast it ?  */
  int server_status;		     /* UP/DOWN			   */
  int nb_failures;
    /* Server type is entirely custom */
  char *type;
    /* type1: CONDOR %d */
  int nb_disks;
  char **disks;
  int *diskspaces;
} NS_ServerDesc;

/**
 **  FUNCTION PROTOTYPES
 **/

void freeServerDesc(void*);
NS_ServerDesc *newServerDesc();
int compServerDescKey(void*,void*);
int sendServerDesc(NS_Communicator*,NS_ServerDesc*);
NS_ServerDesc *recvServerDesc(NS_Communicator*);
#ifdef sunos
int serverOrder(void *,void *);
#else
int serverOrder(const void *,const void *);
#endif

#endif

