/*****************************************************************/
/*      netsolveproxy.h                                          */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_NETSOLVEPROXY_H
#define __NS_NETSOLVEPROXY_H

#include "netsolvejobdesc.h"
#include "communicator.h"

/**
 ** TYPE DEFINITIONS
 **/

typedef struct _NS_NotificationWaiter {
  int id;
  struct _NS_NotificationWaiter * next;
  NS_Communicator * comm;
} NS_NotificationWaiter;

/**
 ** GLOBAL VARIABLES
 **/
char *agent;
int myport;
NS_IPaddr_type myIPaddr;
int life_link;

NS_JobDesc **jobs;

extern NS_NotificationWaiter* notification_waiters;


/**
 **  FUNCTION PROTOTYPES
 **/

void proxyProcessRequest(NS_Communicator*,int);

void processLifeLink(NS_Communicator*);
void processKillJob(NS_Communicator*);
void processNewJobDesc(NS_Communicator*);
void processRmJobDesc(NS_Communicator*);
void processJobReport(NS_Communicator*);
void processProblemInfo(NS_Communicator*);
void processSendRequest(NS_Communicator*);
void processSend_sequence_Request(NS_Communicator *);
void processSendAssignment(NS_Communicator*);
void processServerFailure(NS_Communicator*);
void processProbeRequest(NS_Communicator*);
void processAwaitCompletion(NS_Communicator*);
void processJobCompleted(NS_Communicator*);

int submitProblemToAgent(char*,int,int,int,int*,char***,
                         NS_IPaddr_type**,int**,int**,int**,char*);
int submitProblemToServer(NS_ProblemDesc*, NS_IPaddr_type,int,int*,int*,int*);
int submitProblemToServer_sequence(NS_Node *top_node,NS_IPaddr_type IPaddr,
				   int port, int *start_time, int *newport, int *pid);
NS_ServerDesc *getAServer(NS_IPaddr_type,char*);
int insertJobDesc(NS_JobDesc*);
int requestInsertJobDesc(NS_JobDesc*);
void rmJobDesc(int);
int forwardFailure(NS_IPaddr_type,char*,int);

#endif

