/*****************************************************************/
/*      netsolve.h                                               */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_NETSOLVE_H
#define __NS_NETSOLVE_H

#include "dsi.h"
#include "netsolveerror.h"

/* data types */
#define NETSOLVE_NOTYPE   0 /* No type        */
#define NETSOLVE_I        1 /* Integer        */
#define NETSOLVE_S        2 /* Simple         */
#define NETSOLVE_D        3 /* Double         */
#define NETSOLVE_C        4 /* Simple complex */
#define NETSOLVE_Z        5 /* Double complex */
#define NETSOLVE_CHAR     6 /* Unsigned char  */
#define NETSOLVE_B        7 /* Byte (no XDR)  */

/* Sequences */
extern void*    NS_EndArg;           
#define NS_NULL   &NS_EndArg

/* Iterator */

typedef struct{
  char *expression;
}NS_IntIterator;

typedef struct{
  int *array;
  char *expression;
}NS_IntArrayIterator;

typedef struct{
  void **array;
  char *expression;
}NS_PtrArrayIterator;


typedef struct {
  int type;
  union {
    NS_IntIterator *int_iterator;
    NS_IntArrayIterator *int_array_iterator;
    NS_PtrArrayIterator *ptr_array_iterator;
  } it;
} NS_SpecificIterator;

typedef struct {
  int returned_type;
  int i;
  NS_SpecificIterator *specific;
}NS_Iterator;

NS_Iterator *ns_int(char*);
NS_Iterator *ns_int_array(int*,char*);
NS_Iterator *ns_ptr_array(void**,char*);

int netslmajor(char*);
void netslerr(int);

int netsl(char*,...);
int netslnb(char*,...);
int netslwt(int);
int netslpr(int);

int ns_storehandle(DSI_OBJECT*, char*);
DSI_OBJECT* ns_gethandle(char*);

int netslpr_assignment(int);
int netslwt_assignment(int,int*);
int netsl_assignment(char*,...);
int netslnb_assignment(char*,...);

int *netsl_farm(char*,...);

void    netsl_sequence_begin();     
int     netsl_sequence_end(void*,...);  
int     netsl_sequence_status();

extern int ns_errno;

#define ns_perror(x) \
  fprintf(stderr, "%s: %s\n", x, netsolveErrorMessage(ns_errno));

#endif
