/*****************************************************************/
/*      linkedlist.h                                             */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_LINKEDLIST_H
#define __NS_LINKEDLIST_H


/**
 **  STRUCTURE DEFINITIONS
 **/

typedef struct NS_LinkItem_ NS_LinkItem;
typedef struct NS_LinkedList_ NS_LinkedList;

struct NS_LinkItem_ {
  struct NS_LinkItem_ *next;   /*  Regular doubly */
  struct NS_LinkItem_ *prev;   /*  linked list    */
  void *content;            
};

struct NS_LinkedList_ {
  struct NS_LinkItem_ *start;
};

/**
 ** FUNCTION PROTOTYPES
 **/
NS_LinkedList *newNSLinkedList();
NS_LinkItem *newNSLinkItem(void*);
void **NSitemLookup(NS_LinkedList*,void*,int (*)(void*,void*));
void NSitemDelete(NS_LinkedList*,void*,int (*)(void*,void*),void (*)(void*));
void NSitemInsert(NS_LinkedList*,void*);
int NScountList(NS_LinkedList*);

#endif

