/*****************************************************************/
/*      infoserver.h                                             */
/*      Jakob Oestergaard                                        */
/*---------------------------------------------------------------*/
/*  header for use by the agent and users of the InfoServer      */
/*****************************************************************/

#ifndef __NS_INFOSERVER_H
#define __NS_INFOSERVER_H

#include <time.h>

/*
 * Definitions whoever spawns the InfoServer
 */

#define NS_IS_INPUT_PORT 8998
#define NS_IS_CLIENT_PORT 8999
#define NS_IS_MAX_REQLEN 1024

int spawn_infoserver(void);
void remote_infoserver(const char* hostname, int port);

/*
 * Type declarations of the InfoServer database data 
 * structures
 */

typedef struct {
  unsigned event_id;
  time_t event_time;
  const char * servername;
  const char * event;
} NS_IS_ServerEvent;

typedef struct {
  unsigned event_id;
  time_t event_time;
  int jobid;
  const char * event;
} NS_IS_JobEvent;

/*
 * Input routines for the InfoServer, for use by the
 * agent
 */


/*
 * Agent/(other_client) API:
 *
 * 1: ************************************************************************
 * info_add_keyval(const char * key, const char * value);  // repeat call as needed
 * eventually:  info_add_intkeyval(const char* key, unsigned i)
 *              info_add_fpkeyval(const char * key, double d)
 *              etc. etc. 
 * info_submit(); // call when all keys have values
 *
 * 2: ************************************************************************
 * info_submit(const char*[] keys, const char*[] values); // eg. { "host", "load", 0 }, { "torc0", "1.2", 0 }
 *
 * 3: ************************************************************************
 * info_submit(const char*[] keyvals); // eg. { "host=\"torc0\"", "load=\"1.2\"", 0 }
 *
 * 4: ************************************************************************
 * info_submit(const char* keystring); // eg. "host=\"torc0\" load=\"1.2\""
 *
 * Often we have all needed values as string/other variables already
 * separated out.  Maybe (1) is by far the easiest API to use.
 *
 */

void info_add_keyval(const char* key, const char* val);
void info_add_keyval_int(const char * key, int val);
void info_add_keyval_ulong(const char * key, unsigned long val);
void info_submit(void);

/*
 * InfoServer clients definitions
 */

#endif

