/*****************************************************************/
/*      globusproxy.h                                            */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_GLOBUSPROXY_H
#define __NS_GLOBUSPROXY_H

#include "netsolvejobdesc.h"

/**
 ** MACRO DEFINITIONS
 **/


/**
 ** GLOBAL VARIABLES
 **/
char *agent;
int myport;
NS_IPaddr_type myIPaddr;
int life_link;

NS_JobDesc **jobs;

/**
 **  FUNCTION PROTOTYPES
 **/

void proxyProcessRequest(NS_Communicator*,int);

void processLifeLink(NS_Communicator*);
void processKillJob(NS_Communicator*);
void processNewJobDesc(NS_Communicator*);
void processRmJobDesc(NS_Communicator*);
void processJobReport(NS_Communicator*);
void processProblemInfo(NS_Communicator*);
void processSendRequest(NS_Communicator*);
void processSend_sequence_Request(NS_Communicator *);
void processSendAssignment(NS_Communicator*);
void processServerFailure(NS_Communicator*);
void processProbeRequest(NS_Communicator*);
void processJobCompleted(NS_Communicator*);

int submitProblemToAgent(char*,int,int,int,int*,char***,
                         NS_IPaddr_type**,int**,int**,int**,char*);
int submitProblemToServer(NS_ProblemDesc*,NS_IPaddr_type,int,int*,int*,int*);
NS_ServerDesc *getAServer(NS_IPaddr_type,char*);
int insertJobDesc(NS_JobDesc*);
int requestInsertJobDesc(NS_JobDesc*);
void rmJobDesc(int);
int forwardFailure(NS_IPaddr_type,char*,int);

#endif

