#ifndef __DSI_H
#define __DSI_H 1

#include <sys/types.h>
#ifdef DSI_IBP
#include "ibp_protocol.h"
#include "ibp_client.h"
#include "ibp_base.h"
#endif

#define IBP 1
#define GASS 2

typedef int dsi_type;

typedef struct {
  int flag;
  int perm;
  uid_t uid;
  dsi_type storage_system;
#if defined(DSI)
  union{
#ifdef DSI_IBP
    struct{
      IBP_depot depot;
      IBP_set_of_caps cap;
    }ibp;
#endif
  }dsi_specifics;
#endif
  int written_count;
}DSI_FILE;


typedef struct{
  char *name;
  DSI_FILE* dsi_file;
  int offset;
}DSI_OBJECT;

int insert_dsi_file(DSI_FILE* dsi_file); /* inserts the dsi file */
int remove_dsi_file(DSI_FILE* dsi_file); /* removes the dsi file */

int insert_dsi_object(DSI_OBJECT* dsi_obj); /* inserts the dsi_object */
int remove_dsi_object(DSI_OBJECT* dsi_obj); /* removes the dsi object */
int is_dsi_object(void* obj); /* checks to see if the passed argument is a dsi 
				object . If yes, returns 1, else returns 0 */

DSI_FILE* ns_dsi_open(char* host_name, int flag, int permissions, int
                      size, dsi_type storage_system);
int ns_dsi_close(DSI_FILE* dsi_file);
DSI_OBJECT* ns_dsi_write_vector(DSI_FILE* dsi_file, void* data, int count, 
			int data_type);
DSI_OBJECT* ns_dsi_write_matrix(DSI_FILE* dsi_file, void* data, int rows, 
				int cols, int data_type);
int ns_dsi_read_vector(DSI_OBJECT* ds_obj, void* data, 
			int count, int data_type);
int ns_dsi_read_matrix(DSI_OBJECT* ds_obj, void* data, 
			int rows, int cols, int data_type);
#endif
