/*****************************************************************/
/*      communicator.h                                           */
/*	Henri Casanova					         */
/*---------------------------------------------------------------*/

#ifndef __NS_COMMUNICATOR_H
#define __NS_COMMUNICATOR_H

/*****************************************************************/

#include "dsi.h"
/**
 **  MACRO DEFINITIONS
 **/

/* Buffer size for the file accesses */
#define BUFFSIZE 8192

/* types of transfers: XDR or not */
#define DATA_RAW 0
#define DATA_XDR 1

/* data types */
#define NETSOLVE_NOTYPE   0 /* No type        */
#define NETSOLVE_I        1 /* Integer        */
#define NETSOLVE_S        2 /* Simple         */
#define NETSOLVE_D        3 /* Double         */
#define NETSOLVE_C        4 /* Simple complex */
#define NETSOLVE_Z        5 /* Double complex */
#define NETSOLVE_CHAR     6 /* Unsigned char  */
#define NETSOLVE_B        7 /* Byte (no XDR)  */


/**
 **  STRUCTURE DEFINITIONS
 **/

typedef struct NS_Communicator_ NS_Communicator;

/*  Communicator 
 *
 *  This structure contains the socket descriptor
 *  and the current encoding
 */

struct NS_Communicator_ {
#ifndef WIN32
  int sock;
#else /* WIN32 */
  SOCKET sock;
#endif /* WIN32 */

  int encoding;
};

/*  scomplex and dcomplex
 *
 * Faking complex data types
 */
typedef struct {
  float r;
  float i;
} scomplex;

typedef struct {
  double r;
  double i;
} dcomplex;


/**
 **  FUNCTION PROTOTYPES
 **/

int setXDRSizes();

#ifndef WIN32
NS_Communicator *newCommunicator(int,int);
NS_Communicator *initTransaction(int,int);
NS_Communicator *acceptTransaction(int);
#else /* WIN32 */
NS_Communicator *newCommunicator(SOCKET,int);
NS_Communicator *initTransaction(SOCKET,int);
NS_Communicator *acceptTransaction(SOCKET);
#endif /* WIN32 */
void endTransaction(NS_Communicator*);
int sendArray(NS_Communicator*,int,void*,int);
int recvArray(NS_Communicator*,int,void*,int);
int sendInt(NS_Communicator*,int);
int recvInt(NS_Communicator*,int*);
int sendString(NS_Communicator*,char*);
int recvString(NS_Communicator*,char**);
int sendIPaddr(NS_Communicator*,NS_IPaddr_type*);
int recvIPaddr(NS_Communicator*,NS_IPaddr_type*);
int netsolve_sizeof(int);
int netsolve_xdrsizeof(int);
int sendArrayFromFile(NS_Communicator*,int,int,int);
int recvArrayToFile(NS_Communicator*,int,int,int);
int sendFileAsString(NS_Communicator*,char*);

int recv8BitFlag(NS_Socket_type,int*);
int send8BitFlag(NS_Socket_type,int);

int sendDsiObj(NS_Communicator*, DSI_OBJECT*);
int recvDsiObj(NS_Communicator*, DSI_OBJECT*);
#endif
