/*****************************************************************/
/*      cfortranclient.h                                         */
/*      Henri Casanova, Dorian Arnold                            */
/*****************************************************************/

#ifndef __NS_CFORTRANCLIENT_H
#define __NS_CFORTRANCLIENT_H
#include <stdarg.h>
#include "client.h"


/**
 ** MACRO DEFINITIONS
 **/

#define NS_CALL_FROM_FORTRAN 0
#define NS_CALL_FROM_C       1

#define NB_MAX_REQUESTS 100

/**
 ** GLOBAL VARIABLES
 **/
NS_RequestDesc *requests[NB_MAX_REQUESTS];
void **output_ptrs[NB_MAX_REQUESTS];

int proxy_pid;
int proxy_port;

/**
 ** FUNCTION PROTOTYPES
 **/

int assignConstantValues(NS_ProblemDesc*,NS_Object**,NS_Object**);
int assignFormulaValues(NS_ProblemDesc*,NS_Object**,NS_Object**);
int netslX(char *, va_list, int, int, int);
int netslmajor(char*);

#ifndef WIN32 /*UNIX*/
int netsl(char*,...);
int netslnb(char*,...);
int netslwt(int);
int netslpr(int);
int netslpr_assignment(int);
int netslwt_assignment(int,int*);
int netslkill(int);
void netslerr(int);
int *netsl_farm(char*,...);

int netsl_assignment(char*,...);
int netslnb_assignment(char*,...);

#if defined(F2CADD_) || defined(F2CADD__)
  #define fnetsl fnetsl_
  #define fnetslerr fnetslerr_
  #define fnetslmajor fnetslmajor_
  #define fnetslnb fnetslnb_
  #define fnetslpr fnetslpr_
  #define fnetslwt fnetslwt_
#endif

#ifdef F2CUPCASE 
  #define fnetsl FNETSL
  #define fnetslerr FNETSLERR
  #define fnetslmajor FNETSLMAJOR
  #define fnetslnb FNETSLNB
  #define fnetslpr FNETSLPR
  #define fnetslwt FNETSLWT
#endif

void fnetsl(char*,...);
void fnetslerr(int*);
void fnetslmajor(char*);
void fnetslnb(char*,...);
void fnetslpr(int*,int*);
void fnetslwt(int*,int*);

#else /* WIN32 */

#ifdef WIN32DLL /* Glue for Win32 Dynamic Link Library calls */
HINSTANCE gNetsolveDLL = NULL;
typedef int (*NETSL)(char *,...);
NETSL netsl;
typedef int (*NETSLNB)(char *,...);
NETSLNB netslnb;
typedef int (*NETSLWT)(int);
NETSLWT netslwt;
typedef int (*NETSLPR)(int);
NETSLPR netslpr;
typedef int (*NETSLERR)(int);
NETSLERR netslerr;
typedef int (*NETSL_FARM)(char *,...);
NETSL_FARM netsl_farm;

#else /* Otherwise just declare function prototypes */
int netsl(char*,...);
int netslnb(char*,...);
int netslwt(int);
int netslpr(int);
void netslerr(int);
int *netsl_farm(char*,...);

#endif  /* WIN32DLL */

#endif /* WIN32 */

#endif /* __NS_CFORTRANCLIENT_H */
