/*****************************************************************/
/*      agentdesc.h                                              */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_AGENTDESC_H
#define __NS_AGENTDESC_H


/**
 **  STRUCTURE DEFINITIONS
 **/

/*
 * NS_AgentDesc
 *
 *  Contains all the information on an agent
 */

typedef struct {
  NS_HostDesc *host_desc; 	/* Host descriptor */
  int port; 		/* IP port number  */
} NS_AgentDesc;

/**
 **  FUNCTION PROTOTYPES
 **/

void freeAgentDesc(void*);
NS_AgentDesc *newAgentDesc();
int compAgentDescKey(void*,void*);
int sendAgentDesc(NS_Communicator*,NS_AgentDesc*);
NS_AgentDesc *recvAgentDesc(NS_Communicator*);
#ifdef sunos
int agentOrder(void *,void*);
#else
int agentOrder(const void *,const void*);
#endif

#endif

