/*  In order for this program to work the files which are accessed   */
/*  must have their protection set to 666.                           */
/*  Sometime I should use - chdir("~nanet"); and remove all the      */
/*  path names.                                                      */

# include <sys/types.h>
# include <pwd.h>
# include <stdio.h>
# include <sysexits.h>
# include <ctype.h>
# include <sys/file.h>

# define TRUE		1
# define FALSE		0

# define MAXLENGTH      125      /* maximum size of a line or address */ 

FILE  *fopen(), 
      *fp_temp,             /* a temporary file used for deleting     */ 
      *fp_date,             /* used to obtain the date                */ 
      *fp_debug,            /* for debugging purposes                 */ 
      *fp_next_message,     /* the next message to be processed       */
      *fp_message,          /* the message to be forwarded on or back */ 
      *fp_store,            /* store the message as it is being read  */ 
      *fp_master,           /* master database file                   */
      *fp_lastname,         /* sorted by real lastname                */ 
      *fp_na,               /* sorted by na address                   */
      *fp_help,             /* instructions on how to use the NA-net  */
      *fp_log,              /* A log file containing - To: & From:'s  */
      *fp_collect,          /* stores messages to na.digest           */
      *fp_combined,         /* contains all addresses in random order */
      *fp_addresses,        /* A file containing all addresses to     */
                            /* mail the message too.  Use for         */
                            /* removing membership and changing addr. */
      *fp_netlib;           /* Used for the netlib database           */


int   WHO_TO = 1;   /*  1 - send a message back          */
                    /*  2 - forward the message          */
                    /*  3 - send both forward and back   */ 
                    /*  4 - mail to addresses in the     */ 
                    /*      file "addresses.txt"         */


int   SEND_BACK_THEIR_MESSAGE = TRUE;   
                  /*  e.g. if someone sends mail to na.sendlist the    */
                  /*  message they sent, if any, will not be returned  */   
                  /*  In this case SEND_BACK_THEIR_MESSAGE will be     */
                  /*  set to FALSE.                                    */
 

 

main ()
  {
     char year[MAXLENGTH], month_in_digits[MAXLENGTH], day[MAXLENGTH]; 
     char time[MAXLENGTH], line[MAXLENGTH], from_address[MAXLENGTH];
     char from_name[MAXLENGTH], temp[MAXLENGTH], na_lastname[MAXLENGTH];
     char forward_to_addr[MAXLENGTH], argv_1[MAXLENGTH], ascii_argc[MAXLENGTH];
     int  position = 0, i, j;
     int  blank_line_found = FALSE;
     int  from_is_ok = FALSE, to_is_ok = FALSE;
     int  argv_is_ok = FALSE, argc_is_ok = FALSE; 
     int  argc;

     sleep (4);    /* Wait for previous message to be sent. */

     fp_debug = fopen("/usr/cfs1/nanet/debug", "a");
     fprintf(fp_debug, "\n\n******************************************** \n");
     fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
     fclose(fp_message);                                       /* clear out old message */

     fp_store = fopen("/usr/cfs1/nanet/store", "w");
     fp_log = fopen("/usr/cfs1/nanet/log.txt", "a");
     get_date (year, month_in_digits, day, time);     
     fprintf (fp_debug, "date = %4s%3s%3s%6s \n", year, month_in_digits, day, time);

     fp_next_message = fopen("/usr/cfs1/nanet/next_mail.message", "r");
     while (fgets(line, sizeof line, fp_next_message) != NULL)
       {
         fprintf(fp_debug, "%s", line);  

         if ( (strncmp (line, "**** New Message ****", 21) == 0) ||
              (strncmp (line, "argc ", 5) == 0) ||
              (strncmp (line, "argv_1 ", 7) == 0)  )
           {
             /* do no write to store file */
           }
         else
           {
             fprintf(fp_store, "%s", line);
           }

         if (line[0] == '\n')
           {
             if (blank_line_found == FALSE)
               {
                 fprintf(fp_debug, "Blank line found\n"); 
                 blank_line_found = TRUE;
               }
             /* else first blank line has already been found */
           }

         if (blank_line_found == FALSE) 
           {
             if (strncmp(line, "From ", 5) == 0)
               {
                 fprintf(fp_log, "%4s%3s%3s%6s ", year, month_in_digits, day, time);
                 fprintf(fp_log, "%s", line);
                 from_is_ok = TRUE;    
                 get_return_address (line, from_address); 
                 find_name(from_address, from_name); 

                 /**************** More address checking *********************/
                 if (strcmp(from_name, "MAILER-DAEMON\0") == 0) {
                   fprintf(fp_debug, "ERROR from name is MAILER-DAEMON \n");
                   from_is_ok = FALSE;
                 }
                 /**************** End address checking *********************/
               }
             else if (strncmp(line, "To:", 3) == 0)  
               {                           
                 /* The destination is now read from the command line */
                 fprintf( fp_log, "%17s%s", " ", line);
                 to_is_ok = TRUE;
               }
             else if (strncmp(line, "argc", 4) == 0)  
               {                           
                 get_word (line, temp, &position);
                 remove_spaces (line, &position);
                 get_word (line, ascii_argc, &position);
                 argc = atoi (ascii_argc);
                 fprintf(fp_debug, "ARGC = %d\n", argc); 
                 if (argc > 1)
                   argc_is_ok = TRUE; 
               }
             else if (strncmp(line, "argv_1", 6) == 0)  
               {                           
                 get_word (line, temp, &position);
                 remove_spaces (line, &position);
                 get_word (line, argv_1, &position);
                 strncpy(na_lastname, argv_1, (strlen(argv_1) - 1) ); 
                 fprintf(fp_debug, "To = %s\n", na_lastname);
                 argv_is_ok = TRUE; 

                 /***************************
                 if (strncmp(argv[1], "netlibd", 7) == 0) {
                   fprintf(fp_debug, "ERROR - argv[1] = netlibd \n");
                  argv_is_ok = FALSE;                              
                 *************/
               }
             else 
              {
              }

           }       /* end if blank_line_found */ 

        }               
     fclose (fp_next_message);
     fclose (fp_store);
     fclose (fp_log);

     if (from_is_ok  &&  to_is_ok  &&  argv_is_ok  && argc_is_ok) { 
       form_mail_message(from_address, na_lastname, forward_to_addr);
       append_store_file_to_message ();
       send_mail (from_address, forward_to_addr);   
     }
     else
       {
          fprintf(fp_debug, "Error in either: from, to, or argv. \n");
          fprintf(fp_debug, "from-is-ok %d \n", from_is_ok);
          fprintf(fp_debug, "to-is-ok %d \n", to_is_ok);
          fprintf(fp_debug, "argv-is-ok %d \n", argv_is_ok);
          fprintf(fp_debug, "argc-is-ok %d \n", argc_is_ok);
      
          /************* Maybe uncomment this some time. ******** 
          if (from_is_ok) {
            WHO_TO = 1;
            SEND_BACK_THEIR_MESSAGE= TRUE;
            fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
            fprintf(fp_message, "The recipient's address was not readable by ");
            fprintf(fp_message, "the NA-NET mailer. \n\n");
            fprintf(fp_message, "Your message is being returned. \n");
            fprintf(fp_message, "Please try again or send e-mail to: \n");
            fprintf(fp_message, "  rosener@cs.utk.edu or dongarra@cs.utk.edu \n\n");
            fprintf(fp_message, "Please indicate the error - \"Recipients address was ");
            fprintf(fp_message, "not READABLE\"\nwas delivered. \n\n");
            fclose (fp_message);
            append_store_file_to_message ();
            send_mail (from_address, from_address);  
          }
          **************************************************************/

       }
}                      /* end main  */





/*  An example is given for rosener at cs.utk.edu sending a mail    */
/*  message to na.bsmith@surfer.epm.ornl.gov where smith's real     */ 
/*  address is smith@cs.abc.cba.                                    */

form_mail_message(from_address, na_lastname, forward_to_addr) 
char  from_address [MAXLENGTH];      /* e.g. rosener@cs.utk.edu  */ 
char  na_lastname [MAXLENGTH];       /* e.g. bsmith              */ 
char  forward_to_addr [MAXLENGTH];   /* e.g. smith@cs.abc.cba    */ 
  {

    if (strcmp(na_lastname, "sendlist\0") == 0) {
      WHO_TO = 1;
      send_entire_list();    
      SEND_BACK_THEIR_MESSAGE = FALSE;
    }
    else if (strcmp(na_lastname, "help\0") == 0) {
      WHO_TO = 1;
      send_help();    
      SEND_BACK_THEIR_MESSAGE = FALSE;
    }
    else if (strcmp(na_lastname, "join\0") == 0) {
      WHO_TO = 1;
      new_member_is_joining ( );
      SEND_BACK_THEIR_MESSAGE = FALSE;
    }
    else if (strcmp(na_lastname, "remove\0") == 0) {
      WHO_TO = 1;
      remove_member(from_address);    
      SEND_BACK_THEIR_MESSAGE = FALSE;
    }
    else if (strcmp(na_lastname, "change\0") == 0) {
      WHO_TO = 1;
      change_email_address(from_address);    
      SEND_BACK_THEIR_MESSAGE = FALSE;
    }
    else if (strcmp(na_lastname, "digest\0") == 0) {
      WHO_TO = 1;
      append_to_collect_file();
      SEND_BACK_THEIR_MESSAGE = FALSE;
    }
   
    /********************* For Netlib ************************/
    else if (strcmp(na_lastname, "netlib-add") == 0) {
      WHO_TO = 1;
      fprintf(fp_debug, "MESSAGE is to netlib-add \n");
      add_to_netlib_database ( ); 
      SEND_BACK_THEIR_MESSAGE = FALSE;
    }
    else if (strcmp(na_lastname, "whois") == 0) {
      WHO_TO = 1;
      fprintf(fp_debug, "MESSAGE is to whois \n");
      whois_netlib ( ); 
      SEND_BACK_THEIR_MESSAGE = FALSE;
    }
    /***************** End Netlib section *******************/

    else  {
      send_to_individ (na_lastname, forward_to_addr);
    }
  }



append_to_collect_file()
  {
    char  line[MAXLENGTH];

    fp_store = fopen("/usr/cfs1/nanet/store", "r");
    fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
    fp_collect = fopen("/usr/spool/mail/collect", "a");

    fprintf(fp_debug, "Mail sent to digest. \n");
    fprintf(fp_collect, "\n\n");
    while (fgets(line, sizeof line, fp_store) != NULL)
      {
        fprintf(fp_collect, "%s", line);
      }

    fprintf(fp_message, "Thank you for using the NA-NET. \n\n");
    fprintf(fp_message, "Your mail message has been entered into the ");
    fprintf(fp_message, "digest collection. \n ");

    fclose(fp_collect);
    fclose(fp_store);
    fclose(fp_message);
  }



change_email_address (from_address)
char  from_address[MAXLENGTH];
  {
    int  position = 0;
    int  found_last_name = FALSE, found_first_name = FALSE;
    int  found_key = FALSE, found_new_email_address = FALSE;
    char line[MAXLENGTH], temp_word[MAXLENGTH];
    char last_name[MAXLENGTH], first_name[MAXLENGTH];
    char key[MAXLENGTH], new_address[MAXLENGTH];

    fp_store = fopen("/usr/cfs1/nanet/store", "r");
    while (fgets(line, sizeof line, fp_store) != NULL) 
      {
         position = 0;
         remove_spaces(line, &position);
         get_word(line, temp_word, &position);       
         if (my_strcasecmp(temp_word, "Lastname:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, last_name);          
            fprintf(fp_debug, "Lastname = %s \n", last_name);
            found_last_name = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Firstname:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, first_name);          
            fprintf(fp_debug, "Firstname = %s \n", first_name);
            found_first_name = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Key:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, key);          
            fprintf(fp_debug, "Key = %s \n", key);
            found_key = TRUE;
         }
         else if (my_strcasecmp(temp_word, "New-address:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, new_address);          
            fprintf(fp_debug, "new_address = %s \n", new_address);
            found_new_email_address = TRUE;
         }
         else 
           {
           } 
      }           

      my_word_to_lower (last_name);
      my_word_to_lower (first_name);
      my_word_to_lower (key);
      my_word_to_lower (new_address);





    fclose(fp_store);
    fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
    if (found_last_name && found_first_name && found_key && found_new_email_address) { 
      if (change_email_addr_in_file (last_name, first_name, new_address, 
                                                         key, from_address) == TRUE) 
        {
          fprintf(fp_message, "Your NA-NET email address has been successfully changed to: \n");
          fprintf(fp_message, "%s\n", new_address);
          fprintf(fp_debug, "system returned = %d\n", system("/usr/cfs1/nanet/convert"));
        }
      else 
        {
          fprintf(fp_message, "Your email address has NOT been successfully ");
          fprintf(fp_message, "changed.  \n\n");
          fprintf(fp_message, "Please try again or send mail to ");
          fprintf(fp_message, "nanet@na-net.ornl.gov \n");
        }
    }
    else
      {   
        fprintf(fp_debug,   "Error in change_email_address \n");
        fprintf(fp_message, "Your email address was not changed because ");
        fprintf(fp_message, "one or more \nof the following four values ");
        fprintf(fp_message, "were not specified. \n\n");
        fprintf(fp_message, "Lastname: \n");
        fprintf(fp_message, "Firstname: \n");
        fprintf(fp_message, "Key: \n");
        fprintf(fp_message, "New-address: \n");
      }
    fclose(fp_message);
  }




change_email_addr_in_file (last_name, first_name, new_address, key, from_address)
char last_name[MAXLENGTH];
char first_name[MAXLENGTH];
char new_address[MAXLENGTH];
char key[MAXLENGTH];
char from_address[MAXLENGTH];
  {
    char line[MAXLENGTH], temp_word[MAXLENGTH], old_address[MAXLENGTH];
    int position, print_to_file; 
    int address_was_changed = FALSE;
    int counter1, counter2, temp_strlen;

    /************************************************************/
    /*  e.g.  rosener, bill (na.brosener) rosener@cs.utk.edu    */ 
    /************************************************************/

    fp_temp   = fopen("/usr/cfs1/nanet/temp.nanet_update", "w");
    fp_master = fopen("/usr/cfs1/nanet/nanet_names.master", "r");
    fp_addresses = fopen("/usr/cfs1/nanet/addresses.txt", "w");
    fprintf(fp_addresses, "%s\n", from_address);
    if (strcmp (from_address, new_address) !=0) {
      fprintf(fp_addresses, "%s\n", new_address);
      /* Putting new address into the file because different. */
      fprintf(fp_debug, "Address requesting the change was different\n");
    }
    WHO_TO = 4;
    while (fgets(line, sizeof line, fp_master) !=NULL)  {
       position = 0;
       print_to_file = TRUE;
       get_word(line, temp_word, &position);             /* lastname - rosener */
             
       if (strcmp(temp_word, last_name) == 0)  {
          remove_spaces (line, &position);
          get_word(line, temp_word, &position);          /* firstname - bill */
          if (strcmp(temp_word, first_name) == 0)  {
            remove_spaces (line, &position);
            get_word(line, temp_word, &position);          /* (na. */
            remove_spaces (line, &position);
            get_word(line, temp_word, &position);          /* key - brosener) */
            temp_strlen = strlen (temp_word);
            temp_word[temp_strlen -1] = '\0';              /* remove ")" */
            fprintf(fp_debug, "key = %s\n", temp_word);
            if (strcmp(temp_word, key) ==0)  {
              print_to_file = FALSE;   
              address_was_changed = TRUE;
              remove_spaces (line, &position);
              copy_line (line, position, old_address); 
              fprintf(fp_debug, "Old address was = %s\n", old_address);

              /*************** Send mail to new address too ******************/ 
              if ( (strcmp (from_address, old_address) != 0) &&
                   (strcmp(new_address, old_address) !=0)  )
                {
                fprintf(fp_addresses, "%s\n", old_address);
                /* Also  send change to old address. */
                fprintf(fp_debug, "Sending change to old address too. \n");
              }
             /**************** End mail to new address **********************/ 

            }
          } 
       }



       if (print_to_file == TRUE) {
          fprintf(fp_temp, "%s", line);
       }
       else
         {
            fprintf(fp_debug, "%s, %s (na.%s) %s\n", last_name, first_name,
                                                          key, new_address);
            fprintf(fp_temp, "%s, %s (na.%s) %s\n", last_name, first_name,
                                                          key, new_address);
         }
 
    }  /* end while */ 
    fclose (fp_addresses);
    fclose (fp_temp);
    fclose (fp_master);
    if (address_was_changed == TRUE) {
       fp_temp   = fopen("/usr/cfs1/nanet/temp.nanet_update", "r");
       fp_master = fopen("/usr/cfs1/nanet/nanet_names.master", "w");
       while (fgets(line, sizeof line, fp_temp) != NULL) {
          fprintf(fp_master, "%s", line);
       }
       fclose (fp_temp);
       fclose (fp_master);
       fprintf(fp_debug, "returning TRUE\n");
       return (TRUE);
    }
    else 
      {
         WHO_TO = 1; 
         fprintf(fp_debug, "returning FALSE\n");
         return(FALSE);
      }
  } 




remove_member(from_address)
char from_address[MAXLENGTH];
  {
    int  position = 0;
    int  found_last_name = FALSE, found_first_name = FALSE;
    int  found_key = FALSE;
    char last_name[MAXLENGTH], first_name[MAXLENGTH];
    char key[MAXLENGTH], line[MAXLENGTH], temp_word[MAXLENGTH]; 

    fp_store = fopen("/usr/cfs1/nanet/store", "r");
    while (fgets(line, sizeof line, fp_store) != NULL) 
      {
         position = 0;
         remove_spaces(line, &position);
         get_word(line, temp_word, &position);       
         if (my_strcasecmp(temp_word, "Lastname:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, last_name);          
            fprintf(fp_debug, "Lastname = %s \n", last_name);
            found_last_name = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Firstname:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, first_name);          
            fprintf(fp_debug, "Firstname = %s \n", first_name);
            found_first_name = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Key:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, key);          
            fprintf(fp_debug, "Key = %s \n", key);
            found_key = TRUE;
         }
         else 
           {
           } 
      }           




    fclose(fp_store);
    fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
    if (found_last_name && found_first_name && found_key)  { 
      if (remove_name_from_file (last_name, first_name, key, from_address) == TRUE) 
        {
          fprintf(fp_message, "You have been successfully removed from the ");
          fprintf(fp_message, "NA-NET list. \n\n");
          fprintf(fp_message, "The address of the person making this request was: ");
          fprintf(fp_message, "%s", from_address);
          fprintf(fp_debug, "system returned = %d\n", system("/usr/cfs1/nanet/convert"));
        }
      else 
        {
          fprintf(fp_message, "You have NOT been successfully removed from the ");
          fprintf(fp_message, "NA-NET list. \n");
          fprintf(fp_message, "Please try again or send mail to ");
          fprintf(fp_message, "nanet@na-net.ornl.gov \n");
        }
    }
    else
      {   
        fprintf(fp_debug,   "Error in remove \n");
        fprintf(fp_message, "You were NOT removed from the NA-NET because one  \n");
        fprintf(fp_message, "or more of the following values were not specified.\n\n");
        fprintf(fp_message, "Lastname: \n");
        fprintf(fp_message, "Key: \n");
        fprintf(fp_message, "Firstname: \n");
      }
    fclose(fp_message);
  }



remove_name_from_file (last_name, first_name, key, from_address)
char last_name[MAXLENGTH];
char first_name[MAXLENGTH];
char key[MAXLENGTH];
char from_address[MAXLENGTH];
  {
    char line[MAXLENGTH], temp_word[MAXLENGTH], old_address[MAXLENGTH];
    int position, print_to_file; 
    int name_was_deleted = FALSE;
    int counter1, counter2, temp_strlen;

 
    /************************************************************/
    /*  e.g.  rosener, bill (na.brosener) rosener@cs.utk.edu    */ 
    /************************************************************/

    fp_temp   = fopen("/usr/cfs1/nanet/temp.nanet_update", "w");
    fp_master = fopen("/usr/cfs1/nanet/nanet_names.master", "r");
    fp_addresses = fopen("/usr/cfs1/nanet/addresses.txt", "w");
    fprintf(fp_addresses, "%s\n", from_address);   
                                       /* Put requesting address into the file. */
    WHO_TO = 4; 
    while (fgets(line, sizeof line, fp_master) !=NULL)  {
       position = 0;
       print_to_file = TRUE;
       get_word(line, temp_word, &position);             /* lastname - rosener */
             
       if (strcmp(temp_word, last_name) == 0)  {
          remove_spaces (line, &position);
          get_word(line, temp_word, &position);          /* firstname - bill */
          if (strcmp(temp_word, first_name) == 0)  {
            remove_spaces (line, &position);
            get_word(line, temp_word, &position);          /* (na. */
            remove_spaces (line, &position);
            get_word(line, temp_word, &position);          /* key - brosener) */
            
            temp_strlen = strlen (temp_word);
            temp_word[temp_strlen - 1] = '\0';
            fprintf(fp_debug, "Key = %s\n", temp_word);

            if (strcmp(temp_word, key) == 0)  {
              print_to_file = FALSE;   
              name_was_deleted = TRUE;
              remove_spaces (line, &position);
              copy_line(line, position, old_address);

              /******************** Send to old_address too ***********************/
              if (strcmp (old_address, from_address) != 0) {
                fprintf(fp_addresses, "%s\n", old_address);   
                /* Put deleted address into the file since different. */
                fprintf(fp_debug, "Address requesting the delete was different\n");
                fprintf(fp_debug, "Old address deleted = %s\n", old_address);
              }
              /******************** End send to old address ***********************/

            }
          } 
       }
       if (print_to_file == TRUE) {
          fprintf(fp_temp, "%s", line);
       }
       else
         {
            fprintf(fp_debug, "Deleted - %s\n", line);
            /* delete this entry (i.e. do nothing */
         }
 
    }  /* end while */ 



    fclose (fp_temp);
    fclose (fp_master);
    fclose (fp_addresses);
    if (name_was_deleted == TRUE) {
       fp_temp   = fopen("/usr/cfs1/nanet/temp.nanet_update", "r");
       fp_master = fopen("/usr/cfs1/nanet/nanet_names.master", "w");
       while (fgets(line, sizeof line, fp_temp) != NULL) {
          fprintf(fp_master, "%s", line);
       }
       fclose (fp_temp);
       fclose (fp_master);
       return (TRUE);
    }
    else 
      {
         return(FALSE);
      }
  } 




new_member_is_joining ()
  {
    int  position = 0;
    int  found_last_name = FALSE, found_first_name = FALSE;
    int  found_key = FALSE, found_addr = FALSE;
    char line[MAXLENGTH];
    char last_name[MAXLENGTH], first_name[MAXLENGTH];
    char key[MAXLENGTH], e_mail_addr[MAXLENGTH], temp_word[MAXLENGTH];

    fp_store = fopen("/usr/cfs1/nanet/store", "r");
    while (fgets(line, sizeof line, fp_store) != NULL) 
      {
         position = 0;
         remove_spaces(line, &position);
         get_word(line, temp_word, &position);       
         if (my_strcasecmp(temp_word, "Lastname:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, last_name);          
            fprintf(fp_debug, "Lastname = %s \n", last_name);
            found_last_name = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Firstname:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, first_name);          
            fprintf(fp_debug, "Firstname = %s \n", first_name);
            found_first_name = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Key:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, key);          
            fprintf(fp_debug, "Key = %s \n", key);
            found_key = TRUE;
         }
         else if (my_strcasecmp(temp_word, "E-mail:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, e_mail_addr);          
            fprintf(fp_debug, "E-mail = %s \n", e_mail_addr);
            found_addr = TRUE;
         }
         else 
           {
           } 
      }           
      my_word_to_lower (last_name);
      my_word_to_lower (first_name);
      my_word_to_lower (key);
      my_word_to_lower (e_mail_addr);



    fclose(fp_store);
    fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
    if (found_last_name && found_first_name && found_addr) {
      if (found_key == FALSE) {
        strcpy(key, last_name);
      }
      if (key_is_unique(key) ) {
         fprintf(fp_debug, "Join - key is unique \n");
         fp_master = fopen("/usr/cfs1/nanet/nanet_names.master", "a");
         if (found_key == FALSE) {
           fprintf(fp_master, "%s, %s (na.%s) %s\n", last_name, first_name, 
                                                   last_name, e_mail_addr);
         }
         else {
           fprintf(fp_master, "%s, %s (na.%s) %s\n", last_name, first_name, 
                                                   key, e_mail_addr);
         } 
         fclose (fp_master);      
         fprintf(fp_message, "You have been successfully joined to the NA-NET list \n");
         fprintf(fp_debug, "system returned = %d\n", system("/usr/cfs1/nanet/convert"));
      } 
      else
       {
         fprintf(fp_debug,   "Error in join - lastname is not unique \n");
         fprintf(fp_message, "You were NOT successfully joined to the NA-NET. \n\n");
         fprintf(fp_message, "Since your lastname is not unique, you must now use a \n");
         fprintf(fp_message, "key field.  Submit the same request but this time also \n");
         fprintf(fp_message, "include a key field as shown below.  For the Key: field \n");
         fprintf(fp_message, "try prepending your first initial to your last name.\n\n");
         fprintf(fp_message, "Lastname: rosener \n");
         fprintf(fp_message, "Firstname: bill \n");
         fprintf(fp_message, "Key: brosener \n");
         fprintf(fp_message, "E-mail: test@abc.def.ghi \n");

       }
    }
    else
      {
         fprintf(fp_debug,   "Error in join - missing one of 3 things. \n");
         fprintf(fp_message, "You were NOT successfully joined to the NA-NET because \n");
         fprintf(fp_message, "one or more of the following values were missing: \n");
         fprintf(fp_message, "Lastname: \n");
         fprintf(fp_message, "Firstname: \n");
         fprintf(fp_message, "E-mail: \n");
      }
    fclose(fp_message);
  }




key_is_unique(key)
char key[MAXLENGTH];
  {
    int  position; 
    char line[MAXLENGTH];
    char temp_na[MAXLENGTH];
    int  found = FALSE;

     
    fp_na = fopen("/usr/cfs1/nanet/nanet_names.na", "r");
    while (fgets(line, sizeof line, fp_na) != NULL) 
      {
         position = 0;  
         get_word(line, temp_na, &position);
         if (strcmp(temp_na, key) == 0)  {
           found = TRUE;
           fclose (fp_na);
           return(FALSE);
         }
      }
    fclose (fp_na);
    if (found == FALSE)
      return(TRUE);  
  }



send_help() 
  {
    int  position; 
    char line[MAXLENGTH];
    char  entry[MAXLENGTH], temp_name[MAXLENGTH];
      
    fp_help = fopen("/usr/cfs1/nanet/help.txt", "r");
    fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
    while (fgets(line, sizeof line, fp_help) != NULL) 
      {
        fprintf(fp_message, "%s", line);  
      }
    fclose (fp_help);
    fclose (fp_message);
  }                /* end function */

      





send_entire_list() 
  {
    int  position, i;
    char line[MAXLENGTH];
    char  entry[MAXLENGTH], temp_name[MAXLENGTH];
      
    fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
    fprintf(fp_message, "Thank you for using NA-NET. \n\n");  
    fprintf(fp_message, "Below is a list of the current members.\n\n");  

    fp_master = fopen("/usr/cfs1/nanet/nanet_names.master", "r");
    while (fgets(line, sizeof line, fp_master) != NULL) 
      {
        fprintf(fp_message, "%s", line);  
      }
    fclose (fp_master);
    fclose (fp_message);
  }                /* end function */





send_to_individ (na_lastname, forward_to_addr)
char  na_lastname [MAXLENGTH];
char  forward_to_addr [MAXLENGTH];
  {
    int  position, i, found = FALSE;
    char line[MAXLENGTH],  temp_name[MAXLENGTH];
    
    
    WHO_TO = 1;
    fp_na = fopen("/usr/cfs1/nanet/nanet_names.na", "r");
    while ((fgets(line, sizeof line, fp_na) != NULL) && 
           (found == FALSE) ) 
      {
         position = 0;
         get_word (line, temp_name, &position);
         if (strcmp(temp_name, na_lastname) == 0) 
           {
              found = TRUE;
              WHO_TO = 2;
              remove_spaces(line, &position);
              copy_line (line, position, forward_to_addr);
           } 
       }              /* end while */
     fclose (fp_na);
     if (found == FALSE) {
       search_lastnames (na_lastname);  
     } 
  }                /* end function */





search_lastnames (na_lastname)
char  na_lastname [MAXLENGTH];
  {
    int  printed = FALSE, found = FALSE, position;
    char line[MAXLENGTH],  temp_name[MAXLENGTH];
   
    fp_lastname = fopen("/usr/cfs1/nanet/nanet_names.last", "r");
    fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
    while (fgets(line, sizeof line, fp_lastname) != NULL)  {
       position = 0;
       get_word (line, temp_name, &position);
       if (strcmp(na_lastname, temp_name) == 0)  {
          found = TRUE;
          if (printed == FALSE)  {
             printed = TRUE;
             fprintf(fp_message,"Ambiguous key: try one of the following\n\n");
          }
          fprintf(fp_message, "%s", line);  
       } 
    }                                       /* end while */

    if (found == FALSE)
      {
        fprintf(fp_message,"NA-NET key not found.  Message returned.\n\n");
      }
    else
      fprintf(fp_message, "\n");  

    fclose (fp_message);
    fclose (fp_lastname);
     
  }





copy_line (line, position, word)
char  line[MAXLENGTH];
int   position;
char  word[MAXLENGTH];
  {
     int count = 0;

     while (line[position] != '\n' && line[position] != ' ')
       {
          word[count] = line[position];
          position++;
          count++;
       }
     word[count] = '\0'; 
  }



remove_spaces (buffer, position)
char  buffer[MAXLENGTH];
int   *position;
  {
    while (buffer[*position] == ' '  ||  buffer[*position] == ',' ||
           buffer[*position] == '.')
      {
        *position = *position + 1;
      }
  }



get_word (buffer, word, position)
  char  buffer[MAXLENGTH];
  char  word[MAXLENGTH];
  int   *position;
  {
    int count;

    count = 0;
    while (buffer[*position] != ' '  &&  buffer[*position] != '\n'  &&
           buffer[*position] != ','  &&  buffer[*position] != '@'   &&
           buffer[*position] != '.')
      {
        word[count] = buffer[*position];
        *position = *position + 1;
        count = count + 1;
      }
    word[count] = '\0';
  }





get_return_address(line, address)
char line[MAXLENGTH];
char address[MAXLENGTH];
  {
     int  line_count = 5;               /* To remove From  */
     int  address_count = 0;
     int  i;

     for (i=0; i<MAXLENGTH; i++)
       address[i] = ' ';

     while ((line[line_count] != ' ') && (line[line_count] != '\n') )
       { 
         address[address_count] = line[line_count];
         address_count++;
         line_count++; 
       }

     address[address_count] = '\0';

     fprintf(fp_debug, "return address is = %s\n", address); 
  } 




find_name(address, name)
char  address[MAXLENGTH];
char  name[MAXLENGTH];
  {
     int  name_count = 0;              
     int  address_count = 0;
     int  i;

     if (address[address_count] == '@') {
       while (address[address_count] != ':')
         address_count++;
       address_count++;
     } 

     while ((address[address_count] != '@') && (address_count < MAXLENGTH) ) { 
        name[name_count] = address[address_count];
        name_count++;
        address_count++;  
     }

     /* Let us capitalize the first letter of the name */

  }



append_store_file_to_message ()
  {
    char line[MAXLENGTH];

 
    if (SEND_BACK_THEIR_MESSAGE == TRUE)
      {
        fp_store = fopen("/usr/cfs1/nanet/store", "r");
        fp_message = fopen("/usr/cfs1/nanet/message.txt", "a");
        
        if (WHO_TO == 1)   /* indent the message one space */
          {
            while (fgets(line, sizeof line, fp_store) != NULL)
              {
                 fprintf(fp_message, " %s", line);
              }                 /* end while    */
          }
        else    /* Do not indent the message. */
          {    
            while (fgets(line, sizeof line, fp_store) != NULL)
              {
                 fprintf(fp_message, "%s", line);
              }                 /* end while    */
          }

        fclose (fp_store);
        fclose (fp_message); 
      }                     /* end if       */
  }                         /* end function */





get_date (year, month_in_digits, day, time)
char year[MAXLENGTH], month_in_digits[MAXLENGTH];
char day[MAXLENGTH], time[MAXLENGTH];
  {

     char line[MAXLENGTH], temp[MAXLENGTH], month_in_letters[MAXLENGTH];
     int i, position = 0;
   
     (int) fp_date = popen("date", "r");
     fgets(line, MAXLENGTH, fp_date);
     pclose (fp_date);

     /***********************************/
     /*  Wed Nov  7 16:21:17 EST 1990   */
     /***********************************/
      
     get_word (line, temp, &position);     /* Wed - ingore    */
     remove_spaces (line, &position);
     get_word (line, month_in_letters, &position);    /* Nov - month     */
     convert_month_to_number (month_in_letters, month_in_digits);
     remove_spaces (line, &position);
     get_word (line, day, &position);      /* 7 - day         */
     remove_spaces (line, &position);
     get_word (line, temp, &position);     /* 16:21:17 - time */ 
     for (i=0; i<5; i++) {
       time[i] = temp[i];
     }
     time[i] = '\0';
     remove_spaces (line, &position);
     get_word (line, temp, &position);    /* EST - time zone */ 
     remove_spaces (line, &position);
     get_word (line, year, &position);    /* 1990 - year     */ 
     remove_spaces (line, &position);
     
  }




convert_month_to_number (month_in_letters, month_in_digits)
char month_in_letters[MAXLENGTH];
char month_in_digits[MAXLENGTH];
  {
    if (strncmp(month_in_letters, "Jan", 3) == 0)  {
      strcpy(month_in_digits, "1");
    }    
    else if (strncmp(month_in_letters, "Feb", 3) == 0)  {
      strcpy(month_in_digits, "2");
    }    
    else if (strncmp(month_in_letters, "Mar", 3) == 0)  {
      strcpy(month_in_digits, "3");
    }    
    else if (strncmp(month_in_letters, "Apr", 3) == 0)  {
      strcpy(month_in_digits, "4");
    }    
    else if (strncmp(month_in_letters, "May", 3) == 0)  {
      strcpy(month_in_digits, "5");
    }    
    else if (strncmp(month_in_letters, "Jun", 3) == 0)  {
      strcpy(month_in_digits, "6");
    }    
    else if (strncmp(month_in_letters, "Jul", 3) == 0)  {
      strcpy(month_in_digits, "7");
    }    
    else if (strncmp(month_in_letters, "Aug", 3) == 0)  {
      strcpy(month_in_digits, "8");
    }    
    else if (strncmp(month_in_letters, "Sep", 3) == 0)  {
      strcpy(month_in_digits, "9");
    }    
    else if (strncmp(month_in_letters, "Oct", 3) == 0)  {
      strcpy(month_in_digits, "10");
    }    
    else if (strncmp(month_in_letters, "Nov", 3) == 0)  {
      strcpy(month_in_digits, "11");
    }    
    else if (strncmp(month_in_letters, "Dec", 3) == 0)  {
      strcpy(month_in_digits, "12");
    }    
    else 
      {
      }    
  }  



my_word_to_lower (word)
char word[MAXLENGTH];
  {
     int count =0;
 
     while (word[count] != '\0') 
       {
          if (isupper(word[count]))
            word[count] = tolower(word[count]);
          count++;
       } 
  }


my_strcasecmp (first_word, second_word)
char first_word[MAXLENGTH];
char second_word[MAXLENGTH];
  {
    char word1[MAXLENGTH];
    char word2[MAXLENGTH];
    int count = 0;
    int still_ok = TRUE;
    char  char1, char2;

    strcpy(word1, first_word);
    strcpy(word2, second_word);

    /* Note returns 0 when true */
    while (still_ok)
      {
        if (word1[count] == '\0' && word2[count] != '\0') {
          return (1);
        }
        if (word1[count] != '\0' && word2[count] == '\0') {
          return (1);
        }
        if (word1[count] == '\0' && word2[count] == '\0') {
          return (0);
        }
        if (isupper(word1[count]))
          char1 = tolower(word1[count]);
        else
          char1 = word1[count];

        if (isupper(word2[count]))
          char2 = tolower(word2[count]);
        else
          char2 = word2[count];

        if (char1 == char2) {
          count++;
        }
        else
          {
            return(1);
          }
      }
  }



send_mail (from_address, forward_to_addr)
char from_address[MAXLENGTH];
char forward_to_addr[MAXLENGTH];
  {
        char send_to[MAXLENGTH];
        char myname[MAXLENGTH];
        char *sendmail_argv [10];
        int i;

        fprintf(fp_debug, "WHO_TO = %d\n", WHO_TO);
      
        if (WHO_TO == 1)
          {
            strcpy(send_to, from_address);
          } 
        else if (WHO_TO == 2) 
          {
            strcpy(send_to, forward_to_addr);
          }
        else if (WHO_TO == 3) 
          {
            /* No operation does this yet */
          }
        else if (WHO_TO == 4) 
          {
            strcpy(send_to, "na-addresses");
          }
        else
          {
             fprintf(fp_debug, "error in WHO_TO\n ");
          } 

        fprintf(fp_debug, "from_address = %s\n", from_address);
        fprintf(fp_debug, "send_to = %s\n", send_to);

        /*********************************************  
        i = 0;
        sendmail_argv [i++] = "sendmail";
        sendmail_argv [i++] = from_address; 
        sendmail_argv [i++] = send_to; 
        sendmail_argv [i++] = NULL;  
        setuid(geteuid());
        **********************************************/


        fclose(fp_debug);

        /* find the message to send */
        fp_message = freopen("/usr/cfs1/nanet/message.txt", "r", stdin);

      execl("/usr/lib/sendmail", "sendmail", "-f", from_address, send_to, NULL); 

  }

