
# include <stdio.h>
# include <sys/file.h>

# define MAXLENGTH     125      /*  maximum size of a line or address    */ 
# define TRUE          1
# define FALSE         0

FILE  *fopen(),
      *fp_debug,                /*  debug file                            */
      *fp_date,                 /*  a pipe for reading the date           */
      *fp_log,                  /*  log file containing - To: & From:'s   */
      *fp_usage,                /*  indicates yesterday's usage of na-net */ 
      *fp_collect,              /*  find number of messages in collect    */ 
      *fp_addresses;            /*  mail usage reports to                 */

int NUMBER_OF_MESSAGES_IN_COLLECT = 0;



 
main ()
  {
     char  year[MAXLENGTH],            year_in_log_file[MAXLENGTH];
     char  month_in_digits[MAXLENGTH], month_in_log_file[MAXLENGTH];
     char  day[MAXLENGTH],             day_in_log_file[MAXLENGTH];
     char  line[MAXLENGTH],            month_in_letters[MAXLENGTH];
     char  temp[MAXLENGTH],            who_to_in_log_file[MAXLENGTH];
     int   messages_to_sendlist = 0,  messages_to_help = 0, messages_to_join = 0;
     int   messages_to_remove = 0,  messages_to_change = 0, messages_to_digest = 0;
     int   messages_to_individuals = 0; 
     int   messages_sent_today = 0, position = 0;    


     /***** Keep one week's worth of debug files. *********/
     system ("cp /usr/cfs1/nanet/debug5 /usr/cfs1/nanet/debug6");
     system ("cp /usr/cfs1/nanet/debug4 /usr/cfs1/nanet/debug5");
     system ("cp /usr/cfs1/nanet/debug3 /usr/cfs1/nanet/debug4");
     system ("cp /usr/cfs1/nanet/debug2 /usr/cfs1/nanet/debug3");
     system ("cp /usr/cfs1/nanet/debug1 /usr/cfs1/nanet/debug2");
     system ("cp /usr/cfs1/nanet/debug /usr/cfs1/nanet/debug1");
     fp_debug = fopen("/usr/cfs1/nanet/debug", "w");
     fclose (fp_debug);

   system ("cp /usr/cfs1/nanet/nanet_names.master /usr/cfs1/nanet/nanet_names.master1");
     /**************************************************/
 
     fp_usage = fopen("/usr/cfs1/nanet/CRON/usage.txt", "w");
     fp_log   = fopen("/usr/cfs1/nanet/log.txt", "r");
     get_date(year, month_in_digits, month_in_letters, day);
    
  /* printf("date = %4s%3s%3s%3s \n", year, month_in_digits, month_in_letters, day); */

     while (fgets(line, sizeof line, fp_log) != NULL) {
       position = 0;
       get_word (line, year_in_log_file, &position);     
       if (strncmp(year_in_log_file, year, 4) == 0) {
         remove_spaces (line, &position);
         get_word (line, month_in_log_file, &position);     
         if (strncmp(month_in_log_file, month_in_digits, strlen(month_in_digits)) == 0) {
           remove_spaces (line, &position);
           get_word (line, day_in_log_file, &position);     
           if (strncmp(day_in_log_file, day, strlen(day) ) == 0) {
             if (fgets(line, sizeof line, fp_log) != NULL) {
               remove_spaces (line, &position);
               get_word (line, temp, &position);   /* To: */ 
               if (strncmp ("To:", temp, 3) == 0) {
                 messages_sent_today++;
                 remove_spaces (line, &position);
                 get_word (line, temp, &position);   /* na. */ 
                 remove_spaces (line, &position);
                 get_word (line, who_to_in_log_file, &position);   /* who to */ 
                 if (strncmp (who_to_in_log_file, "sendlist", 8) == 0) 
                   messages_to_sendlist++;
                 else if (strncmp (who_to_in_log_file, "help", 4) == 0) 
                   messages_to_help++;
                 else if (strncmp (who_to_in_log_file, "join", 4) == 0)
                   messages_to_join++;
                 else if (strncmp (who_to_in_log_file, "remove", 6) == 0)
                   messages_to_remove++;
                 else if (strncmp (who_to_in_log_file, "change", 6) == 0)
                   messages_to_change++;
                 else if (strncmp (who_to_in_log_file, "digest", 6) == 0)
                   messages_to_digest++;
                 else 
                   messages_to_individuals++;
               }
             }
           }
         }
       }
     }


     find_number_of_messages_in_collect ( );   
     fprintf(fp_usage, "\nNA-NET usage \n\n");
     fprintf(fp_usage, "%d mail message(s) were sent ", messages_sent_today);
     fprintf(fp_usage, "to the NA-NET on: %s %s \n\n", month_in_letters, day);
     fprintf(fp_usage, "Analysis of mail messages sent today: \n\n");
     fprintf(fp_usage, "   To na.sendlist = %d \n", messages_to_sendlist);
     fprintf(fp_usage, "   To na.help     = %d \n", messages_to_help);
     fprintf(fp_usage, "   To na.join     = %d \n", messages_to_join);
     fprintf(fp_usage, "   To na.remove   = %d \n", messages_to_remove);
     fprintf(fp_usage, "   To na.change   = %d \n", messages_to_change);
     fprintf(fp_usage, "   To na.digest   = %d \n", messages_to_digest);
     fprintf(fp_usage, "   To individuals = %d \n\n", messages_to_individuals);

     fprintf(fp_usage, "There are currently %d ", NUMBER_OF_MESSAGES_IN_COLLECT);
     fprintf(fp_usage, "mail messages in the collect file.\n\n");

     fclose(fp_log);
     fclose(fp_usage);

     mail_usage_reports (); 
  }




find_number_of_messages_in_collect( )    
  {
    char line[MAXLENGTH];
    
    fp_collect   = fopen("/usr/spool/mail/collect", "r");
    while (fgets(line, sizeof line, fp_collect) != NULL) 
      {
         /*  fprintf (fp_usage, "%s", line);  */
         if (strncmp(line, "From ", 5) == 0)  
           {
               NUMBER_OF_MESSAGES_IN_COLLECT++; 
           }
      }
    fclose(fp_collect);
  }



mail_usage_reports ()
  {
    char from_address[MAXLENGTH], send_to[MAXLENGTH];


    fp_usage = freopen("/usr/cfs1/nanet/CRON/usage.txt", "r", stdin);

    strcpy(from_address, "nanet");
    strcpy(send_to, "na-usage");

    execl("/usr/lib/sendmail", "sendmail", "-f", "nanet", "na-usage", NULL);  

  }



get_date(year, month_in_digits, month_in_letters, day)
char year[MAXLENGTH], month_in_digits[MAXLENGTH];
char month_in_letters[MAXLENGTH], day[MAXLENGTH]; 
  {

     char line[MAXLENGTH], temp[MAXLENGTH];
     int i, position = 0;

     (int) fp_date = popen("date", "r");
     fgets(line, MAXLENGTH, fp_date);
     pclose (fp_date);

     /***********************************/
     /*  Wed Nov  7 16:21:17 EST 1990   */
     /***********************************/

     get_word (line, temp, &position);     /* Wed - ingore    */
     remove_spaces (line, &position);
     get_word (line, month_in_letters, &position);    /* Nov - month     */
     convert_month_to_number (month_in_letters, month_in_digits);
     remove_spaces (line, &position);
     get_word (line, day, &position);      /* 7 - day         */

     /* To try a certain day for the current month */
     /*  strcpy (day, "8");                        */

     remove_spaces (line, &position);
     get_word (line, temp, &position);     /* 16:21:17 - time */

     remove_spaces (line, &position);
     get_word (line, temp, &position);    /* EST - time zone */
     remove_spaces (line, &position);
     get_word (line, year, &position);    /* 1990 - year     */
     remove_spaces (line, &position);
  }



convert_month_to_number (month_in_letters, month_in_digits)
char month_in_letters[MAXLENGTH], month_in_digits[MAXLENGTH];
  {
    if (strncmp(month_in_letters, "Jan", 3) == 0)  {
      strcpy(month_in_digits, "1");
    }
    else if (strncmp(month_in_letters, "Feb", 3) == 0)  {
      strcpy(month_in_digits, "2");
    }
    else if (strncmp(month_in_letters, "Mar", 3) == 0)  {
      strcpy(month_in_digits, "3");
    }
    else if (strncmp(month_in_letters, "Apr", 3) == 0)  {
      strcpy(month_in_digits, "4");
    }
    else if (strncmp(month_in_letters, "May", 3) == 0)  {
      strcpy(month_in_digits, "5");
    }
    else if (strncmp(month_in_letters, "Jun", 3) == 0)  {
      strcpy(month_in_digits, "6");
    }
    else if (strncmp(month_in_letters, "Jul", 3) == 0)  {
      strcpy(month_in_digits, "7");
    }
    else if (strncmp(month_in_letters, "Aug", 3) == 0)  {
      strcpy(month_in_digits, "8");
    }
    else if (strncmp(month_in_letters, "Sep", 3) == 0)  {
      strcpy(month_in_digits, "9");
    }
    else if (strncmp(month_in_letters, "Oct", 3) == 0)  {
      strcpy(month_in_digits, "10");
    }
    else if (strncmp(month_in_letters, "Nov", 3) == 0)  {
      strcpy(month_in_digits, "11");
    }
    else if (strncmp(month_in_letters, "Dec", 3) == 0)  {
      strcpy(month_in_digits, "12");
    }
    else
      {
      }
  }




remove_spaces (buffer, position)
char  buffer[MAXLENGTH];
int   *position;
  {
    while (buffer[*position] == ' '  ||  buffer[*position] == ',' ||
           buffer[*position] == '.')
      {
        *position = *position + 1;
      }
  }



get_word (buffer, word, position)
  char  buffer[MAXLENGTH];
  char  word[MAXLENGTH];
  int   *position;
  {
    int count;

    count = 0;
    while (buffer[*position] != ' '  &&  buffer[*position] != '\n'  &&
           buffer[*position] != ','  &&  buffer[*position] != '@'   &&
           buffer[*position] != '.')
      {
        word[count] = buffer[*position];
        *position = *position + 1;
        count = count + 1;
      }
    word[count] = '\0';
  }



