/*  This program takes the file "nanet_names.master" and produces  */
/*  the three files "nanet_names.last", "nanet_names.na", and      */
/*  "nanet_names.comb".                                            */

# include <stdio.h>
# include <ctype.h>

# define MAXLENGTH      100      /* maximum size of a line */ 

FILE   *fopen(), 
       *fp_master,          /* master database file     */
       *fp_lastname,        /* sorted by real lastname  */ 
       *fp_na,              /* sorted by na address     */
       *fp_combined;        /* contains all address     */ 



char * 
main ()
  {
     int position;
     char buffer[MAXLENGTH], word[MAXLENGTH];


     
     fp_master = fopen("/usr/cfs1/nanet/nanet_names.master", "r");
     if (fp_master == 0)
       {
          printf("error opening the file nanet_names.master \n");
     }
     fp_lastname = fopen("/usr/cfs1/nanet/nanet_names.last", "w");
     fp_na       = fopen("/usr/cfs1/nanet/nanet_names.na", "w");
     fp_combined = fopen("/usr/cfs1/nanet/nanet_names.comb", "w");

     while (fgets(buffer, MAXLENGTH, fp_master) != NULL)
       {
         position = 0; 
         print_to_real_lastname(0, buffer);
         print_to_na_address (0, buffer);  

         get_word(buffer, word, &position);           /* get last name */ 
         remove_spaces(buffer, &position);
         get_word(buffer, word, &position);           /* get first name */
         remove_spaces(buffer, &position);
         get_word(buffer, word, &position);           /* get na.name    */
         remove_spaces(buffer, &position);
         print_rest_to_combined (position, buffer);
       }            

    fclose(fp_master);
    fclose(fp_lastname);
    fclose(fp_na);
    fclose(fp_combined);

system("sort -o /usr/cfs1/nanet/nanet_names.na /usr/cfs1/nanet/nanet_names.na");    
system("sort -o /usr/cfs1/nanet/nanet_names.last /usr/cfs1/nanet/nanet_names.last");
system("sort -o /usr/cfs1/nanet/nanet_names.master /usr/cfs1/nanet/nanet_names.master");
    

  }                 /* end main  */


 

print_to_na_address (position, buffer)
int  position;
char buffer[MAXLENGTH];
  {
    while (buffer[position] != '.' )  
      {
         position++; 
      }
    position++; 
    while (buffer[position] != '\n' )  
      {
        if (buffer[position] == ')' )
          {
             /* Do nothing */
          }
        else
          {
            fprintf(fp_na, "%c", buffer[position]);
          }
        position++;
      } 
    fprintf(fp_na, "\n");
 
  }



 

print_to_real_lastname (position, buffer)
int  position;
char buffer[MAXLENGTH];
  {
    while (buffer[position] != ')' )  
      {
        if (buffer[position] == '(' )
          {
            fprintf(fp_lastname, "= ");
          }
        else
          {
            fprintf(fp_lastname, "%c", buffer[position]);
          }
        position++;
      } 
    fprintf(fp_lastname, "\n");
  }




print_rest_to_combined (position, buffer)
int  position;
char buffer[MAXLENGTH];
  {
    while (buffer[position] != '\n' && buffer[position] != NULL)
      {
        fprintf(fp_combined, "%c", buffer[position]);
        position++;
      }
    fprintf(fp_combined, "\n");
  }



 
get_word (buffer, word, position)
  char  buffer[MAXLENGTH];
  char  word[MAXLENGTH];
  int   *position;
  {
    int count;

    count = 0;
    while (buffer[*position] != ' '  &&  buffer[*position] != '\n'  &&
           buffer[*position] != EOF  &&  buffer[*position] != NULL)
      {
        word[count] = buffer[*position];
        *position = *position + 1;
        count = count + 1;
      }
    word[count] = '\0';
  }



remove_spaces (buffer, position)
  char  buffer[MAXLENGTH];
  int   *position;
  {
    while (buffer[*position] == ' ')
      {
        *position = *position + 1;
      }
  }



