      real function vecnrm (n,x,normsw)
c
      integer n,normsw
      real x(n)
c
c                                         Coded by Tom Rowan
c                            Department of Computer Sciences
c                              University of Texas at Austin
c
c vecnrm computes the norm of x.
c
c input
c
c   n      - number of components
c
c   x      - real n-vector
c
c   normsw - integer norm switch 
c            = 0 : use infinity-norm
c            = 1 : use 1-norm
c            = 2 : use 2-norm
c
c output
c
c   vecnrm - norm of x
c
c local variables
c
      integer isamax
      real sasum,snrm2
c
c subroutines and functions
c
c   blas
      external isamax,sasum,snrm2
c   fortran
      intrinsic abs
c
c-----------------------------------------------------------
c
      if (normsw .eq. 0) then
        vecnrm = abs(x(isamax(n,x,1)))
      else if (normsw .eq. 1) then
        vecnrm = sasum(n,x,1)
      else
        vecnrm = snrm2(n,x,1)
      end if
      return
      end
